/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.GroupCommandDefinition;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.aesh.io.FileResource;
import org.aesh.io.Resource;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.logging.Messages;
import org.wildfly.security.auth.server.IdentityCredentials;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.CredentialStoreException;
import org.wildfly.security.credential.store.impl.KeyStoreCredentialStore;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.util.PasswordBasedEncryptionUtil;

@GroupCommandDefinition(name="credentials", description="Credential store operations", groupCommands={Add.class, Remove.class, Ls.class, Mask.class})
public class Credentials
extends CliCommand {
    public static final String STORE_TYPE = "pkcs12";
    public static final String CREDENTIALS_PATH = "credentials.pfx";
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public CommandResult exec(ContextAwareCommandInvocation invocation) {
        invocation.println(invocation.getHelpInfo());
        return CommandResult.FAILURE;
    }

    static KeyStoreCredentialStore getKeyStoreCredentialStore(Path path, String type, boolean create, char[] password) throws CredentialStoreException {
        KeyStoreCredentialStore store = new KeyStoreCredentialStore();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("location", path.toAbsolutePath().toString());
        map.put("keyStoreType", type);
        map.put("create", Boolean.toString(create));
        store.initialize(map, (CredentialStore.ProtectionParameter)new CredentialStore.CredentialSourceProtectionParameter((CredentialSource)IdentityCredentials.NONE.withCredential((Credential)new PasswordCredential((Password)ClearPassword.createRaw((String)"clear", (char[])password)))), null);
        return store;
    }

    static Path resourceToPath(Resource resource, String serverRoot) {
        if (((FileResource)resource).getFile().getParent() != null) {
            return Paths.get(resource.getAbsolutePath(), new String[0]);
        }
        String serverHome = System.getProperty("infinispan.server.home.path");
        Path serverHomePath = serverHome == null ? Paths.get("", new String[0]) : Paths.get(serverHome, new String[0]);
        return serverHomePath.resolve(serverRoot).resolve("conf").resolve(((FileResource)resource).getFile().getPath()).toAbsolutePath();
    }

    @CommandDefinition(name="mask", description="Masks the password for a credential keystore.")
    public static class Mask
    extends CliCommand {
        @Argument(description="Specifies the password to mask.", required=true)
        String password;
        @Option(description="Specifies a salt value for the encryption.", shortName=115, required=true)
        String salt;
        @Option(description="Sets the number of iterations.", shortName=105, required=true)
        Integer iterations;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) throws CommandException {
            try {
                PasswordBasedEncryptionUtil pbe = new PasswordBasedEncryptionUtil.Builder().picketBoxCompatibility().salt(this.salt).iteration(this.iterations.intValue()).encryptMode().build();
                invocation.printf("%s;%s;%d%n", pbe.encryptAndEncode(this.password.toCharArray()), this.salt, this.iterations);
                return CommandResult.SUCCESS;
            }
            catch (Exception e) {
                throw new CommandException((Throwable)e);
            }
        }
    }

    @CommandDefinition(name="ls", description="Lists credential aliases in keystores.")
    public static class Ls
    extends CliCommand {
        @Option(description="Sets the path to a credential keystore.", completer=FileOptionCompleter.class, defaultValue={"credentials.pfx"})
        Resource path;
        @Option(description="Specifies the password that protects the credential keystore.", shortName=112)
        String password;
        @Option(description="Sets the type of credential store. Values are either PKCS12, which is the default, or JCEKS.", shortName=116, defaultValue={"pkcs12"})
        String type;
        @Option(description="Sets the path to the server root directory.", defaultValue={"server"}, name="server-root", shortName=115)
        String serverRoot;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) throws CommandException {
            try {
                Path file = Credentials.resourceToPath(this.path, this.serverRoot);
                if (Files.exists(file, new LinkOption[0])) {
                    if (this.password == null) {
                        this.password = invocation.getPasswordInteractively(Messages.MSG.credentialToolPassword(), null);
                    }
                    KeyStoreCredentialStore store = Credentials.getKeyStoreCredentialStore(file, this.type, false, this.password.toCharArray());
                    for (String alias : store.getAliases()) {
                        invocation.println(alias);
                    }
                }
                return CommandResult.SUCCESS;
            }
            catch (Exception e) {
                throw new CommandException((Throwable)e);
            }
        }
    }

    @CommandDefinition(name="remove", description="Deletes credentials from keystores.", aliases={"rm"})
    public static class Remove
    extends CliCommand {
        @Argument(description="Specifies an alias, or name, for the credential.", required=true)
        String alias;
        @Option(description="Sets the path to a credential keystore.", completer=FileOptionCompleter.class, defaultValue={"credentials.pfx"})
        Resource path;
        @Option(description="Specifies the password that protects the credential keystore.", shortName=112)
        String password;
        @Option(description="Sets the type of credential store. Values are either PKCS12, which is the default, or JCEKS.", shortName=116, defaultValue={"pkcs12"})
        String type;
        @Option(description="Sets the path to the server root directory.", defaultValue={"server"}, name="server-root", shortName=115)
        String serverRoot;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) throws CommandException {
            try {
                Path file = Credentials.resourceToPath(this.path, this.serverRoot);
                if (this.password == null) {
                    this.password = invocation.getPasswordInteractively(Messages.MSG.credentialToolPassword(), null);
                }
                KeyStoreCredentialStore store = Credentials.getKeyStoreCredentialStore(file, this.type, false, this.password.toCharArray());
                store.remove(this.alias, PasswordCredential.class, null, null);
                store.flush();
                return CommandResult.SUCCESS;
            }
            catch (Exception e) {
                throw new CommandException((Throwable)e);
            }
        }
    }

    @CommandDefinition(name="add", description="Adds credentials to keystores.")
    public static class Add
    extends CliCommand {
        @Argument(description="Specifies an alias, or name, for the credential.", required=true)
        String alias;
        @Option(description="Sets the path to a credential keystore and creates a new one if it does not exist.", completer=FileOptionCompleter.class, defaultValue={"credentials.pfx"})
        Resource path;
        @Option(description="Specifies a password to protect the credential keystore.", shortName=112)
        String password;
        @Option(description="Sets the type of credential store. Values are either PKCS12, which is the default, or JCEKS.", shortName=116, defaultValue={"pkcs12"})
        String type;
        @Option(description="Adds a credential to the keystore.", shortName=99)
        String credential;
        @Option(description="Sets the path to the server root directory.", defaultValue={"server"}, name="server-root", shortName=115)
        String serverRoot;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) throws CommandException {
            try {
                Path file = Credentials.resourceToPath(this.path, this.serverRoot);
                if (this.password == null) {
                    this.password = invocation.getPasswordInteractively(Messages.MSG.credentialToolPassword(), Files.exists(file, new LinkOption[0]) ? null : Messages.MSG.credentialToolPasswordConfirm());
                }
                if (this.credential == null) {
                    this.credential = invocation.getPasswordInteractively(Messages.MSG.credentialToolCredential(), Messages.MSG.credentialToolCredentialConfirm());
                }
                KeyStoreCredentialStore store = Credentials.getKeyStoreCredentialStore(file, this.type, true, this.password.toCharArray());
                store.store(this.alias, (Credential)new PasswordCredential((Password)ClearPassword.createRaw((String)"clear", (char[])this.credential.toCharArray())), null);
                store.flush();
                return CommandResult.SUCCESS;
            }
            catch (Exception e) {
                throw new CommandException((Throwable)e);
            }
        }
    }
}

