/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.csp;

import java.util.Optional;
import org.htmlunit.csp.Policy;
import org.htmlunit.csp.url.URLWithScheme;

public class PolicyInOrigin {
    private final Policy policy_;
    private final URLWithScheme origin_;

    public PolicyInOrigin(Policy policy, URLWithScheme origin) {
        this.policy_ = policy;
        this.origin_ = origin;
    }

    public Policy getPolicy() {
        return this.policy_;
    }

    public boolean allowsScriptFromSource(URLWithScheme url) {
        return this.policy_.allowsExternalScript(Optional.empty(), Optional.empty(), Optional.of(url), Optional.empty(), Optional.of(this.origin_));
    }

    public boolean allowsStyleFromSource(URLWithScheme url) {
        return this.policy_.allowsExternalStyle(Optional.empty(), Optional.of(url), Optional.of(this.origin_));
    }

    public boolean allowsImageFromSource(URLWithScheme url) {
        return this.policy_.allowsImage(Optional.of(url), Optional.of(this.origin_));
    }

    public boolean allowsFrameFromSource(URLWithScheme url) {
        return this.policy_.allowsFrame(Optional.of(url), Optional.of(this.origin_));
    }

    public boolean allowsWorkerFromSource(URLWithScheme url) {
        return this.policy_.allowsWorker(Optional.of(url), Optional.of(this.origin_));
    }

    public boolean allowsFontFromSource(URLWithScheme url) {
        return this.policy_.allowsFont(Optional.of(url), Optional.of(this.origin_));
    }

    public boolean allowsObjectFromSource(URLWithScheme url) {
        return this.policy_.allowsObject(Optional.of(url), Optional.of(this.origin_));
    }

    public boolean allowsMediaFromSource(URLWithScheme url) {
        return this.policy_.allowsMedia(Optional.of(url), Optional.of(this.origin_));
    }

    public boolean allowsManifestFromSource(URLWithScheme url) {
        return this.policy_.allowsApplicationManifest(Optional.of(url), Optional.of(this.origin_));
    }

    public boolean allowsPrefetchFromSource(URLWithScheme url) {
        return this.policy_.allowsPrefetch(Optional.of(url), Optional.of(this.origin_));
    }

    public boolean allowsUnsafeInlineScript() {
        return this.policy_.allowsInlineScript(Optional.empty(), Optional.empty(), Optional.empty());
    }

    public boolean allowsUnsafeInlineStyle() {
        return this.policy_.allowsInlineStyle(Optional.empty(), Optional.empty());
    }

    public boolean allowsConnection(URLWithScheme url) {
        return this.policy_.allowsConnection(Optional.of(url), Optional.of(this.origin_));
    }

    public boolean allowsNavigation(URLWithScheme url) {
        return this.policy_.allowsNavigation(Optional.of(url), Optional.empty(), Optional.empty(), Optional.of(this.origin_));
    }

    public boolean allowsFrameAncestor(URLWithScheme url) {
        return this.policy_.allowsFrameAncestor(Optional.of(url), Optional.of(this.origin_));
    }

    public boolean allowsFormAction(URLWithScheme url) {
        return this.policy_.allowsFormAction(Optional.of(url), Optional.empty(), Optional.empty(), Optional.of(this.origin_));
    }
}

