/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.internal.reveng.strategy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.HashSetValuedHashMap;
import org.hibernate.mapping.MetaAttribute;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MetaAttributeHelper {
    public static MetaAttribute toRealMetaAttribute(String name, Collection<?> values) {
        MetaAttribute attribute = new MetaAttribute(name);
        for (SimpleMetaAttribute element : values) {
            attribute.addValue(element.value);
        }
        return attribute;
    }

    public static MultiValuedMap<String, SimpleMetaAttribute> loadAndMergeMetaMap(Element classElement, MultiValuedMap<String, SimpleMetaAttribute> inheritedMeta) {
        return MetaAttributeHelper.mergeMetaMaps(MetaAttributeHelper.loadMetaMap(classElement), inheritedMeta);
    }

    public static MultiValuedMap<String, SimpleMetaAttribute> loadMetaMap(Element element) {
        HashSetValuedHashMap result = new HashSetValuedHashMap();
        ArrayList<Element> metaAttributeList = new ArrayList<Element>();
        ArrayList<Element> metaNodes = MetaAttributeHelper.getChildElements(element, "meta");
        for (Element metaNode : metaNodes) {
            metaAttributeList.add(metaNode);
        }
        for (Element metaAttribute : metaAttributeList) {
            String attribute = metaAttribute.getAttribute("attribute");
            String value = metaAttribute.getTextContent();
            String inheritStr = null;
            if (metaAttribute.hasAttribute("inherit")) {
                inheritStr = metaAttribute.getAttribute("inherit");
            }
            boolean inherit = true;
            if (inheritStr != null) {
                inherit = Boolean.valueOf(inheritStr);
            }
            SimpleMetaAttribute ma = new SimpleMetaAttribute(value, inherit);
            result.put((Object)attribute, (Object)ma);
        }
        return result;
    }

    private static MultiValuedMap<String, SimpleMetaAttribute> mergeMetaMaps(MultiValuedMap<String, SimpleMetaAttribute> specific, MultiValuedMap<String, SimpleMetaAttribute> general) {
        HashSetValuedHashMap result = new HashSetValuedHashMap();
        MetaAttributeHelper.copyMultiMap((MultiValuedMap<String, SimpleMetaAttribute>)result, specific);
        if (general != null) {
            for (String key : general.keySet()) {
                if (specific.containsKey((Object)key)) continue;
                Collection ml = general.get((Object)key);
                for (SimpleMetaAttribute element : ml) {
                    if (!element.inheritable) continue;
                    result.put((Object)key, (Object)element);
                }
            }
        }
        return result;
    }

    private static void copyMultiMap(MultiValuedMap<String, SimpleMetaAttribute> destination, MultiValuedMap<String, SimpleMetaAttribute> specific) {
        for (String key : specific.keySet()) {
            Collection c = specific.get((Object)key);
            Iterator valueIterator = c.iterator();
            while (valueIterator.hasNext()) {
                destination.put((Object)key, (Object)((SimpleMetaAttribute)valueIterator.next()));
            }
        }
    }

    private static ArrayList<Element> getChildElements(Element parent, String tagName) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList nodeList = parent.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !tagName.equals(((Element)node).getTagName())) continue;
            result.add((Element)node);
        }
        return result;
    }

    public static class SimpleMetaAttribute {
        String value;
        boolean inheritable = true;

        public SimpleMetaAttribute(String value, boolean inherit) {
            this.value = value;
            this.inheritable = inherit;
        }

        public String toString() {
            return this.value;
        }
    }
}

