/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.predicate.dsl.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.hibernate.search.engine.logging.impl.QueryLog;
import org.hibernate.search.engine.search.common.ValueModel;
import org.hibernate.search.engine.search.common.spi.SearchIndexScope;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.MatchPredicateFieldMoreGenericStep;
import org.hibernate.search.engine.search.predicate.dsl.MatchPredicateFieldMoreStep;
import org.hibernate.search.engine.search.predicate.dsl.MatchPredicateOptionsStep;
import org.hibernate.search.engine.search.predicate.dsl.MinimumShouldMatchConditionStep;
import org.hibernate.search.engine.search.predicate.dsl.impl.AbstractBooleanMultiFieldPredicateCommonState;
import org.hibernate.search.engine.search.predicate.dsl.impl.MinimumShouldMatchConditionStepImpl;
import org.hibernate.search.engine.search.predicate.dsl.spi.SearchPredicateDslContext;
import org.hibernate.search.engine.search.predicate.spi.MatchPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.MinimumShouldMatchBuilder;
import org.hibernate.search.engine.search.predicate.spi.PredicateTypeKeys;
import org.hibernate.search.engine.search.reference.predicate.MatchPredicateFieldReference;
import org.hibernate.search.util.common.impl.Contracts;

abstract class AbstractMatchPredicateFieldMoreStep<CS extends GenericCommonState<T, V, S>, S extends AbstractMatchPredicateFieldMoreStep<CS, S, T, V>, T, V>
implements AbstractBooleanMultiFieldPredicateCommonState.FieldSetState {
    protected final CS commonState;
    protected final Map<V, MatchPredicateBuilder> predicateBuilders = new LinkedHashMap<V, MatchPredicateBuilder>();
    private Float fieldSetBoost;

    public static MatchPredicateFieldMoreStep<?, ?> create(SearchPredicateDslContext<?> dslContext, String[] fields) {
        return new MatchPredicateFieldMoreStepString(dslContext, Arrays.asList(fields));
    }

    public static <SR, T> MatchPredicateFieldMoreGenericStep<?, ?, T, MatchPredicateFieldReference<? super SR, T>> create(SearchPredicateDslContext<?> dslContext, MatchPredicateFieldReference<? super SR, T>[] fields) {
        List<MatchPredicateFieldReference<? super SR, T>> fieldList = Arrays.asList(fields);
        return new MatchPredicateFieldMoreStepFieldReference<SR, T>(dslContext, fieldList);
    }

    protected AbstractMatchPredicateFieldMoreStep(CS commonState, List<V> fieldPaths) {
        this.commonState = commonState;
        ((AbstractBooleanMultiFieldPredicateCommonState)this.commonState).add(this.thisAsS());
        SearchIndexScope<?> scope = ((AbstractBooleanMultiFieldPredicateCommonState)commonState).scope();
        for (V fieldPath : fieldPaths) {
            this.predicateBuilders.put((MatchPredicateBuilder)fieldPath, scope.fieldQueryElement(this.fieldPath(fieldPath), PredicateTypeKeys.MATCH));
        }
    }

    protected abstract S thisAsS();

    protected abstract String fieldPath(V var1);

    public S boost(float boost) {
        this.fieldSetBoost = Float.valueOf(boost);
        return this.thisAsS();
    }

    @Override
    public void contributePredicates(Consumer<SearchPredicate> collector) {
        for (MatchPredicateBuilder predicateBuilder : this.predicateBuilders.values()) {
            ((AbstractBooleanMultiFieldPredicateCommonState)this.commonState).applyBoostAndConstantScore(this.fieldSetBoost, predicateBuilder);
            collector.accept(predicateBuilder.build());
        }
    }

    private static class MatchPredicateFieldMoreStepString
    extends AbstractMatchPredicateFieldMoreStep<CommonState, MatchPredicateFieldMoreStepString, Object, String>
    implements MatchPredicateFieldMoreStep<MatchPredicateFieldMoreStepString, CommonState> {
        MatchPredicateFieldMoreStepString(SearchPredicateDslContext<?> dslContext, List<String> fieldPaths) {
            super(new CommonState(dslContext), fieldPaths);
        }

        private MatchPredicateFieldMoreStepString(CommonState commonState, List<String> fieldPaths) {
            super(commonState, fieldPaths);
        }

        @Override
        protected MatchPredicateFieldMoreStepString thisAsS() {
            return this;
        }

        @Override
        protected String fieldPath(String field) {
            return field;
        }

        @Override
        public MatchPredicateFieldMoreStepString field(String field) {
            return new MatchPredicateFieldMoreStepString((CommonState)this.commonState, Arrays.asList(field));
        }

        public MatchPredicateFieldMoreStepString fields(String ... fieldPaths) {
            return new MatchPredicateFieldMoreStepString((CommonState)this.commonState, Arrays.asList(fieldPaths));
        }

        @Override
        public CommonState matching(Object value, ValueModel valueModel) {
            return ((CommonState)this.commonState).matching(value, valueModel);
        }

        private static class CommonState
        extends GenericCommonState<Object, String, MatchPredicateFieldMoreStepString> {
            CommonState(SearchPredicateDslContext<?> dslContext) {
                super(dslContext);
            }

            CommonState matching(Object value, ValueModel valueModel) {
                Contracts.assertNotNull((Object)value, (String)"value");
                Contracts.assertNotNull((Object)((Object)valueModel), (String)"valueModel");
                for (MatchPredicateFieldMoreStepString fieldSetState : this.getFieldSetStates()) {
                    for (MatchPredicateBuilder predicateBuilder : fieldSetState.predicateBuilders.values()) {
                        predicateBuilder.value(value, valueModel);
                    }
                }
                return this;
            }
        }
    }

    private static class MatchPredicateFieldMoreStepFieldReference<SR, T>
    extends AbstractMatchPredicateFieldMoreStep<CommonState<SR, T>, MatchPredicateFieldMoreStepFieldReference<SR, T>, T, MatchPredicateFieldReference<? super SR, T>>
    implements MatchPredicateFieldMoreGenericStep<MatchPredicateFieldMoreStepFieldReference<SR, T>, CommonState<SR, T>, T, MatchPredicateFieldReference<? super SR, T>> {
        MatchPredicateFieldMoreStepFieldReference(SearchPredicateDslContext<?> dslContext, List<MatchPredicateFieldReference<? super SR, T>> fieldPaths) {
            super(new CommonState(dslContext), fieldPaths);
        }

        private MatchPredicateFieldMoreStepFieldReference(CommonState<SR, T> commonState, List<MatchPredicateFieldReference<? super SR, T>> fieldPaths) {
            super(commonState, fieldPaths);
        }

        @Override
        public MatchPredicateFieldMoreStepFieldReference<SR, T> field(MatchPredicateFieldReference<? super SR, T> field) {
            return new MatchPredicateFieldMoreStepFieldReference<SR, T>((CommonState)this.commonState, Collections.singletonList(field));
        }

        public MatchPredicateFieldMoreStepFieldReference<SR, T> fields(MatchPredicateFieldReference<? super SR, T> ... fieldPaths) {
            return new MatchPredicateFieldMoreStepFieldReference<SR, T>((CommonState)this.commonState, Arrays.asList(fieldPaths));
        }

        @Override
        public CommonState<SR, T> matching(T value) {
            return ((CommonState)this.commonState).matching(value);
        }

        @Override
        protected MatchPredicateFieldMoreStepFieldReference<SR, T> thisAsS() {
            return this;
        }

        @Override
        protected String fieldPath(MatchPredicateFieldReference<? super SR, T> field) {
            return field.absolutePath();
        }

        private static class CommonState<SR, T>
        extends GenericCommonState<T, MatchPredicateFieldReference<? super SR, T>, MatchPredicateFieldMoreStepFieldReference<SR, T>> {
            CommonState(SearchPredicateDslContext<?> dslContext) {
                super(dslContext);
            }

            CommonState<SR, T> matching(T value) {
                Contracts.assertNotNull(value, (String)"value");
                for (MatchPredicateFieldMoreStepFieldReference fieldSetState : this.getFieldSetStates()) {
                    for (Map.Entry entry : fieldSetState.predicateBuilders.entrySet()) {
                        ((MatchPredicateBuilder)entry.getValue()).value(value, ((MatchPredicateFieldReference)entry.getKey()).valueModel());
                    }
                }
                return this;
            }
        }
    }

    static class GenericCommonState<T, V, S extends AbstractMatchPredicateFieldMoreStep<?, S, T, V>>
    extends AbstractBooleanMultiFieldPredicateCommonState<GenericCommonState<T, V, S>, S>
    implements MatchPredicateOptionsStep<GenericCommonState<T, V, S>> {
        private final MinimumShouldMatchConditionStepImpl<? extends GenericCommonState<T, V, S>> minimumShouldMatchStep = new MinimumShouldMatchConditionStepImpl<GenericCommonState>(new MatchMinimumShouldMatchBuilder(), this);

        GenericCommonState(SearchPredicateDslContext<?> dslContext) {
            super(dslContext);
        }

        @Override
        public GenericCommonState<T, V, S> fuzzy(int maxEditDistance, int exactPrefixLength) {
            if (maxEditDistance < 0 || 2 < maxEditDistance) {
                throw QueryLog.INSTANCE.invalidFuzzyMaximumEditDistance(maxEditDistance);
            }
            if (exactPrefixLength < 0) {
                throw QueryLog.INSTANCE.invalidExactPrefixLength(exactPrefixLength);
            }
            for (AbstractMatchPredicateFieldMoreStep fieldSetState : this.getFieldSetStates()) {
                for (MatchPredicateBuilder predicateBuilder : fieldSetState.predicateBuilders.values()) {
                    predicateBuilder.fuzzy(maxEditDistance, exactPrefixLength);
                }
            }
            return this;
        }

        @Override
        public GenericCommonState<T, V, S> analyzer(String analyzerName) {
            for (AbstractMatchPredicateFieldMoreStep fieldSetState : this.getFieldSetStates()) {
                for (MatchPredicateBuilder predicateBuilder : fieldSetState.predicateBuilders.values()) {
                    predicateBuilder.analyzer(analyzerName);
                }
            }
            return this;
        }

        @Override
        public GenericCommonState<T, V, S> skipAnalysis() {
            for (AbstractMatchPredicateFieldMoreStep fieldSetState : this.getFieldSetStates()) {
                for (MatchPredicateBuilder predicateBuilder : fieldSetState.predicateBuilders.values()) {
                    predicateBuilder.skipAnalysis();
                }
            }
            return this;
        }

        @Override
        protected GenericCommonState<T, V, S> thisAsS() {
            return this;
        }

        @Override
        public MinimumShouldMatchConditionStep<? extends GenericCommonState<T, V, S>> minimumShouldMatch() {
            return this.minimumShouldMatchStep;
        }

        @Override
        public GenericCommonState<T, V, S> minimumShouldMatch(Consumer<? super MinimumShouldMatchConditionStep<?>> constraintContributor) {
            constraintContributor.accept(this.minimumShouldMatchStep);
            return this;
        }

        private class MatchMinimumShouldMatchBuilder
        implements MinimumShouldMatchBuilder {
            private MatchMinimumShouldMatchBuilder() {
            }

            @Override
            public void minimumShouldMatchNumber(int ignoreConstraintCeiling, int matchingClausesNumber) {
                for (AbstractMatchPredicateFieldMoreStep fieldSetState : GenericCommonState.this.getFieldSetStates()) {
                    for (MatchPredicateBuilder predicateBuilder : fieldSetState.predicateBuilders.values()) {
                        predicateBuilder.minimumShouldMatchNumber(ignoreConstraintCeiling, matchingClausesNumber);
                    }
                }
            }

            @Override
            public void minimumShouldMatchPercent(int ignoreConstraintCeiling, int matchingClausesPercent) {
                for (AbstractMatchPredicateFieldMoreStep fieldSetState : GenericCommonState.this.getFieldSetStates()) {
                    for (MatchPredicateBuilder predicateBuilder : fieldSetState.predicateBuilders.values()) {
                        predicateBuilder.minimumShouldMatchPercent(ignoreConstraintCeiling, matchingClausesPercent);
                    }
                }
            }
        }
    }
}

