/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.common.spi;

import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.search.common.ValueModel;
import org.hibernate.search.engine.search.common.spi.SearchIndexNodeTypeContext;
import org.hibernate.search.engine.search.common.spi.SearchIndexScope;
import org.hibernate.search.engine.search.highlighter.spi.SearchHighlighterType;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.annotation.Incubating;

public interface SearchIndexValueFieldTypeContext<SC extends SearchIndexScope<?>, N, F>
extends SearchIndexNodeTypeContext<SC, N> {
    public Class<F> valueClass();

    public DslConverter<?, F> mappingDslConverter();

    public DslConverter<F, F> indexDslConverter();

    public DslConverter<?, ?> rawDslConverter();

    @Incubating
    public DslConverter<?, F> parserDslConverter();

    default public DslConverter<?, F> dslConverter(ValueModel valueModel) {
        switch (valueModel) {
            case RAW: {
                throw new AssertionFailure("Raw dsl converter is not supported");
            }
            case INDEX: {
                return this.indexDslConverter();
            }
            case STRING: {
                return this.parserDslConverter();
            }
        }
        return this.mappingDslConverter();
    }

    public ProjectionConverter<?, ?> rawProjectionConverter();

    public ProjectionConverter<F, ?> mappingProjectionConverter();

    public ProjectionConverter<F, F> indexProjectionConverter();

    @Incubating
    public ProjectionConverter<F, ?> formatterProjectionConverter();

    default public ProjectionConverter<F, ?> projectionConverter(ValueModel valueModel) {
        switch (valueModel) {
            case RAW: {
                throw new AssertionFailure("Raw projection converter is not supported");
            }
            case INDEX: {
                return this.indexProjectionConverter();
            }
            case STRING: {
                return this.formatterProjectionConverter();
            }
        }
        return this.mappingProjectionConverter();
    }

    public boolean highlighterTypeSupported(SearchHighlighterType var1);
}

