/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.mariadb;

import java.util.Locale;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.spatial.GeolatteGeometryJavaTypeDescriptor;
import org.hibernate.spatial.GeolatteGeometryType;
import org.hibernate.spatial.JTSGeometryJavaTypeDescriptor;
import org.hibernate.spatial.JTSGeometryType;
import org.hibernate.spatial.SpatialDialect;
import org.hibernate.spatial.SpatialFunction;
import org.hibernate.spatial.dialect.SpatialFunctionsRegistry;
import org.hibernate.spatial.dialect.mariadb.MariaDBGeometryTypeDescriptor;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public interface MariaDBSpatialDialectTrait
extends SpatialDialect {
    default public void delegateContributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        typeContributions.contributeType((BasicType)new GeolatteGeometryType(MariaDBGeometryTypeDescriptor.INSTANCE));
        typeContributions.contributeType((BasicType)new JTSGeometryType(MariaDBGeometryTypeDescriptor.INSTANCE));
        typeContributions.contributeJavaTypeDescriptor((JavaTypeDescriptor)GeolatteGeometryJavaTypeDescriptor.INSTANCE);
        typeContributions.contributeJavaTypeDescriptor(JTSGeometryJavaTypeDescriptor.INSTANCE);
    }

    public SpatialFunctionsRegistry spatialFunctions();

    @Override
    default public String getSpatialRelateSQL(String columnName, int spatialRelation) {
        switch (spatialRelation) {
            case 4: {
                return " ST_within(" + columnName + ",?)";
            }
            case 6: {
                return " ST_contains(" + columnName + ", ?)";
            }
            case 3: {
                return " ST_crosses(" + columnName + ", ?)";
            }
            case 5: {
                return " ST_overlaps(" + columnName + ", ?)";
            }
            case 1: {
                return " ST_disjoint(" + columnName + ", ?)";
            }
            case 7: {
                return " ST_intersects(" + columnName + ", ?)";
            }
            case 2: {
                return " ST_touches(" + columnName + ", ?)";
            }
            case 0: {
                return " ST_equals(" + columnName + ", ?)";
            }
        }
        throw new IllegalArgumentException("Spatial relation is not known by this dialect");
    }

    @Override
    default public String getSpatialFilterExpression(String columnName) {
        return String.format(Locale.ENGLISH, "MBRIntersects(%s,?)", columnName);
    }

    @Override
    default public String getSpatialAggregateSQL(String columnName, int aggregation) {
        throw new UnsupportedOperationException("MariaDB has no spatial aggregate functions.");
    }

    @Override
    default public String getDWithinSQL(String columnName) {
        throw new UnsupportedOperationException("MariaDB doesn't support the DWithin function.");
    }

    @Override
    default public String getHavingSridSQL(String columnName) {
        return " (ST_SRID(" + columnName + ") = ?) ";
    }

    @Override
    default public String getIsEmptySQL(String columnName, boolean isEmpty) {
        String emptyExpr = " ST_IsEmpty(" + columnName + ") ";
        return isEmpty ? emptyExpr : "( NOT " + emptyExpr + ")";
    }

    @Override
    default public boolean supportsFiltering() {
        return true;
    }

    @Override
    default public boolean supports(SpatialFunction function) {
        return this.spatialFunctions().get(function.toString()) != null;
    }
}

