/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.analyzer.impl;

import org.apache.lucene.analysis.Analyzer;
import org.hibernate.search.analyzer.impl.LuceneAnalyzerReference;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class SimpleLuceneAnalyzerReference
extends LuceneAnalyzerReference {
    private static final Log LOG = LoggerFactory.make();
    private Analyzer analyzer;

    public SimpleLuceneAnalyzerReference(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    @Override
    public Analyzer getAnalyzer() {
        if (this.analyzer == null) {
            throw LOG.lazyLuceneAnalyzerReferenceNotInitialized(this);
        }
        return this.analyzer;
    }

    @Override
    public boolean isNormalizer(String fieldName) {
        return false;
    }

    public boolean isInitialized() {
        return true;
    }

    @Override
    public void close() {
        this.analyzer.close();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("<");
        sb.append(this.analyzer);
        sb.append(">");
        return sb.toString();
    }
}

