/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import java.lang.invoke.MethodHandles;
import org.apache.lucene.search.BooleanQuery;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

final class MinimumShouldMatchContextImpl {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private MinimumShouldMatchConstraint minimumShouldMatchConstraint;

    MinimumShouldMatchContextImpl() {
    }

    public void requireNumber(int matchingClausesNumber) {
        this.addMinimumShouldMatchConstraint(new MinimumShouldMatchConstraint(matchingClausesNumber, null));
    }

    public void requirePercent(int matchingClausesPercent) {
        this.addMinimumShouldMatchConstraint(new MinimumShouldMatchConstraint(null, matchingClausesPercent));
    }

    void applyMinimum(BooleanQuery.Builder builder, int shouldClauseCount) {
        if (this.minimumShouldMatchConstraint != null) {
            int minimumShouldMatch = this.minimumShouldMatchConstraint.toMinimum(shouldClauseCount);
            builder.setMinimumNumberShouldMatch(minimumShouldMatch);
        }
    }

    private void addMinimumShouldMatchConstraint(MinimumShouldMatchConstraint constraint) {
        if (this.minimumShouldMatchConstraint != null) {
            throw log.minimumShouldMatchConflictingConstraints();
        }
        this.minimumShouldMatchConstraint = constraint;
    }

    private static final class MinimumShouldMatchConstraint {
        private final Integer matchingClausesNumber;
        private final Integer matchingClausesPercent;

        MinimumShouldMatchConstraint(Integer matchingClausesNumber, Integer matchingClausesPercent) {
            this.matchingClausesNumber = matchingClausesNumber;
            this.matchingClausesPercent = matchingClausesPercent;
        }

        int toMinimum(int totalShouldClauseNumber) {
            int minimum = this.matchingClausesNumber != null ? (this.matchingClausesNumber >= 0 ? this.matchingClausesNumber : totalShouldClauseNumber + this.matchingClausesNumber) : (this.matchingClausesPercent >= 0 ? this.matchingClausesPercent * totalShouldClauseNumber / 100 : totalShouldClauseNumber + this.matchingClausesPercent * totalShouldClauseNumber / 100);
            if (minimum < 1 || minimum > totalShouldClauseNumber) {
                throw log.minimumShouldMatchMinimumOutOfBounds(totalShouldClauseNumber, minimum);
            }
            return minimum;
        }
    }
}

