/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import org.apache.lucene.index.IndexWriter;
import org.hibernate.search.backend.impl.lucene.AbstractCommitPolicy;
import org.hibernate.search.backend.impl.lucene.IndexWriterHolder;
import org.hibernate.search.exception.impl.ErrorContextBuilder;

public final class SharedIndexCommitPolicy
extends AbstractCommitPolicy {
    private final Object lock = new Object();
    private int openWriterUsers = 0;
    private boolean lastExitCloses = false;

    public SharedIndexCommitPolicy(IndexWriterHolder indexWriterHolder) {
        super(indexWriterHolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onChangeSetApplied(boolean someFailureHappened, boolean streaming) {
        Object object = this.lock;
        synchronized (object) {
            --this.openWriterUsers;
            if (this.openWriterUsers == 0) {
                if (someFailureHappened) {
                    this.indexWriterHolder.forceLockRelease();
                } else if (!streaming || this.lastExitCloses) {
                    this.lastExitCloses = false;
                    this.indexWriterHolder.closeIndexWriter();
                }
            } else if (!someFailureHappened && !streaming) {
                this.indexWriterHolder.commitIndexWriter();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFlush() {
        Object object = this.lock;
        synchronized (object) {
            if (this.openWriterUsers == 0) {
                this.indexWriterHolder.closeIndexWriter();
            } else {
                this.lastExitCloses = true;
                this.indexWriterHolder.commitIndexWriter();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexWriter getIndexWriter() {
        Object object = this.lock;
        synchronized (object) {
            IndexWriter indexWriter = super.getIndexWriter();
            if (indexWriter != null) {
                ++this.openWriterUsers;
            }
            return indexWriter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexWriter getIndexWriter(ErrorContextBuilder errorContextBuilder) {
        Object object = this.lock;
        synchronized (object) {
            IndexWriter indexWriter = super.getIndexWriter(errorContextBuilder);
            if (indexWriter != null) {
                ++this.openWriterUsers;
            }
            return indexWriter;
        }
    }
}

