/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.serialization.spi;

import java.util.Properties;
import org.hibernate.search.SearchException;
import org.hibernate.search.engine.ServiceManager;
import org.hibernate.search.indexes.serialization.impl.PluggableSerializationLuceneWorkSerializer;
import org.hibernate.search.indexes.serialization.spi.LuceneWorkSerializer;
import org.hibernate.search.indexes.serialization.spi.SerializationProvider;
import org.hibernate.search.indexes.serialization.spi.SerializationProviderService;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.spi.ServiceProvider;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class SerializerService
implements ServiceProvider<LuceneWorkSerializer> {
    private static final Log log = LoggerFactory.make();
    private PluggableSerializationLuceneWorkSerializer workSerializer;
    private ServiceManager serviceManager;

    @Override
    public void start(Properties properties, BuildContext buildContext) {
        this.serviceManager = buildContext.getServiceManager();
        SerializationProvider serializationProvider = (SerializationProvider)this.serviceManager.requestService(SerializationProviderService.class, buildContext);
        try {
            this.workSerializer = new PluggableSerializationLuceneWorkSerializer(serializationProvider, buildContext.getUninitializedSearchFactory());
        }
        catch (RuntimeException e) {
            if (e instanceof SearchException) {
                throw e;
            }
            throw log.unableToStartSerializationLayer(e);
        }
    }

    @Override
    public LuceneWorkSerializer getService() {
        return this.workSerializer;
    }

    @Override
    public void stop() {
        if (this.workSerializer != null) {
            this.serviceManager.releaseService(SerializationProviderService.class);
        }
    }
}

