/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.util;

import org.graalvm.compiler.serviceprovider.GraalServices;

public class Timer {
    private static boolean disablePrinting = false;
    private String prefix;
    private final String name;
    private final boolean autoPrint;
    private long startTime;
    private long totalTime;
    private long totalMemory;

    public Timer(String name) {
        this(null, name, true);
    }

    public Timer(String prefix, String name) {
        this(prefix, name, true);
    }

    public Timer(String name, boolean autoPrint) {
        this(null, name, autoPrint);
    }

    public Timer(String prefix, String name, boolean autoPrint) {
        this.prefix = prefix;
        this.name = name;
        this.autoPrint = autoPrint;
    }

    public static void disablePrinting() {
        disablePrinting = true;
    }

    public void setPrefix(String value) {
        this.prefix = value;
    }

    public StopTimer start() {
        this.startTime = System.nanoTime();
        return new StopTimer();
    }

    public void stop() {
        long addTime = System.nanoTime() - this.startTime;
        this.totalTime += addTime;
        if (this.autoPrint) {
            this.print(addTime);
        }
    }

    private void print(long time) {
        String concurrentPrefix;
        if (disablePrinting) {
            return;
        }
        if (this.prefix != null) {
            String pid = GraalServices.getExecutionID();
            concurrentPrefix = String.format("[%s:%s] ", this.prefix, pid);
        } else {
            concurrentPrefix = "";
        }
        this.totalMemory = Runtime.getRuntime().totalMemory();
        double totalMemoryGB = (double)this.totalMemory / 1024.0 / 1024.0 / 1024.0;
        System.out.format("%s%12s: %,10.2f ms, %,5.2f GB%n", concurrentPrefix, this.name, (double)time / 1000000.0, totalMemoryGB);
    }

    public void print() {
        this.print(this.totalTime);
    }

    public double getTotalTime() {
        return (double)this.totalTime / 1000000.0;
    }

    public long getTotalMemory() {
        return this.totalMemory;
    }

    public class StopTimer
    implements AutoCloseable {
        @Override
        public void close() {
            Timer.this.stop();
        }
    }
}

