/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.AccessFieldTypeFlow;
import com.oracle.graal.pointsto.flow.FieldTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.typestate.TypeState;
import jdk.vm.ci.code.BytecodePosition;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;

public abstract class LoadFieldTypeFlow
extends AccessFieldTypeFlow {
    protected LoadFieldTypeFlow(LoadFieldNode node) {
        super((ValueNode)node, (AnalysisField)node.field());
    }

    protected LoadFieldTypeFlow(MethodFlowsGraph methodFlows, LoadFieldTypeFlow original) {
        super(original, methodFlows);
    }

    public static class LoadInstanceFieldTypeFlow
    extends LoadFieldTypeFlow {
        private TypeFlow<?> objectFlow;

        LoadInstanceFieldTypeFlow(LoadFieldNode node, TypeFlow<?> objectFlow) {
            super(node);
            this.objectFlow = objectFlow;
        }

        LoadInstanceFieldTypeFlow(PointsToAnalysis bb, MethodFlowsGraph methodFlows, LoadInstanceFieldTypeFlow original) {
            super(methodFlows, original);
            this.objectFlow = methodFlows.lookupCloneOf(bb, original.objectFlow);
        }

        public LoadFieldTypeFlow copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
            return new LoadInstanceFieldTypeFlow(bb, methodFlows, this);
        }

        @Override
        public TypeFlow<?> receiver() {
            return this.objectFlow;
        }

        @Override
        public void setObserved(TypeFlow<?> newObjectFlow) {
            this.objectFlow = newObjectFlow;
        }

        @Override
        public void onObservedUpdate(PointsToAnalysis bb) {
            assert (this.isClone());
            TypeState objectState = this.objectFlow.getState();
            objectState = this.filterObjectState(bb, objectState);
            for (AnalysisObject object : objectState.objects()) {
                FieldTypeFlow fieldFlow = object.getInstanceFieldFlow(bb, this.objectFlow, (BytecodePosition)this.source, this.field, false);
                fieldFlow.addUse(bb, this);
            }
        }

        @Override
        public void onObservedSaturated(PointsToAnalysis bb, TypeFlow<?> observed) {
            assert (this.isClone());
            this.replaceObservedWith(bb, this.field.getDeclaringClass());
        }

        @Override
        public String toString() {
            return "LoadInstanceFieldTypeFlow<" + this.getState() + ">";
        }
    }

    public static class LoadStaticFieldTypeFlow
    extends LoadFieldTypeFlow {
        private final FieldTypeFlow fieldFlow;

        LoadStaticFieldTypeFlow(LoadFieldNode node, FieldTypeFlow fieldFlow) {
            super(node);
            this.fieldFlow = fieldFlow;
        }

        LoadStaticFieldTypeFlow(MethodFlowsGraph methodFlows, LoadStaticFieldTypeFlow original) {
            super(methodFlows, original);
            this.fieldFlow = original.fieldFlow;
        }

        @Override
        public TypeFlow<BytecodePosition> copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
            return new LoadStaticFieldTypeFlow(methodFlows, this);
        }

        @Override
        public void initClone(PointsToAnalysis bb) {
            this.fieldFlow.addUse(bb, this);
        }

        @Override
        public String toString() {
            return "LoadStaticFieldTypeFlow<" + this.getState() + ">";
        }
    }
}

