/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow.context.object;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.flow.ArrayElementsTypeFlow;
import com.oracle.graal.pointsto.flow.FieldFilterTypeFlow;
import com.oracle.graal.pointsto.flow.FieldTypeFlow;
import com.oracle.graal.pointsto.flow.UnsafeWriteSinkTypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.typestore.ArrayElementsTypeStore;
import com.oracle.graal.pointsto.typestore.FieldTypeStore;
import com.oracle.graal.pointsto.util.AnalysisError;
import java.lang.reflect.Modifier;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;

public class AnalysisObject
implements Comparable<AnalysisObject> {
    public static final Comparator<AnalysisObject> objectsTypeComparator = Comparator.comparingInt(o -> o.getTypeId());
    public static final AnalysisObject[] EMPTY_ARRAY = new AnalysisObject[0];
    private static final AtomicInteger nextObjectId = new AtomicInteger();
    protected final long id;
    protected final AnalysisType type;
    protected final AnalysisObjectKind kind;
    protected volatile boolean merged;
    private static final AtomicReferenceFieldUpdater<AnalysisObject, AtomicReferenceArray> INSTANCE_FIELD_TYPE_STORE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(AnalysisObject.class, AtomicReferenceArray.class, "instanceFieldsTypeStore");
    protected final ArrayElementsTypeStore arrayElementsTypeStore;
    protected volatile AtomicReferenceArray<FieldTypeStore> instanceFieldsTypeStore;

    public AnalysisObject(AnalysisUniverse universe, AnalysisType type) {
        this(universe, type, AnalysisObjectKind.ContextInsensitive);
    }

    protected AnalysisObject(AnalysisUniverse universe, AnalysisType type, AnalysisObjectKind kind) {
        this.id = AnalysisObject.createId(type.getId());
        this.type = type;
        this.kind = kind;
        this.merged = false;
        this.arrayElementsTypeStore = universe.analysisPolicy().createArrayElementsTypeStore(this, universe);
    }

    private static long createId(int typeId) {
        long resultId = typeId;
        long objectId = nextObjectId.incrementAndGet();
        resultId = resultId << 32 ^ objectId;
        return resultId;
    }

    public int getTypeId() {
        return (int)(this.id >> 32);
    }

    public AnalysisType type() {
        return this.type;
    }

    public long getId() {
        return this.id;
    }

    public void noteMerge(BigBang bb) {
        this.merged = true;
    }

    public String prefix() {
        return this.kind.prefix;
    }

    public final boolean isContextInsensitiveObject() {
        return this.kind == AnalysisObjectKind.ContextInsensitive;
    }

    public final boolean isAllocationContextSensitiveObject() {
        return this.kind == AnalysisObjectKind.AllocationContextSensitive;
    }

    public final boolean isConstantContextSensitiveObject() {
        return this.kind == AnalysisObjectKind.ConstantContextSensitive;
    }

    public final boolean isContextSensitiveObject() {
        return this.isAllocationContextSensitiveObject() || this.isConstantContextSensitiveObject();
    }

    public ArrayElementsTypeStore getArrayElementsTypeStore() {
        return this.arrayElementsTypeStore;
    }

    public ArrayElementsTypeFlow getArrayElementsFlow(BigBang bb, boolean isStore) {
        assert (this.isObjectArray());
        this.arrayElementsTypeStore.init(bb);
        return isStore ? this.arrayElementsTypeStore.writeFlow() : this.arrayElementsTypeStore.readFlow();
    }

    public FieldFilterTypeFlow getInstanceFieldFilterFlow(BigBang bb, AnalysisMethod context, AnalysisField field) {
        assert (!Modifier.isStatic(field.getModifiers()) && field.isUnsafeAccessed());
        FieldTypeStore fieldTypeStore = this.getInstanceFieldTypeStore(bb, context, field);
        return fieldTypeStore.writeFlow().filterFlow(bb);
    }

    public UnsafeWriteSinkTypeFlow getUnsafeWriteSinkFrozenFilterFlow(BigBang bb, AnalysisMethod context, AnalysisField field) {
        assert (!Modifier.isStatic(field.getModifiers()) && field.hasUnsafeFrozenTypeState());
        FieldTypeStore fieldTypeStore = this.getInstanceFieldTypeStore(bb, context, field);
        return fieldTypeStore.unsafeWriteSinkFlow(bb);
    }

    public FieldTypeFlow getInstanceFieldFlow(BigBang bb, AnalysisField field, boolean isStore) {
        return this.getInstanceFieldFlow(bb, null, field, isStore);
    }

    public FieldTypeFlow getInstanceFieldFlow(BigBang bb, AnalysisMethod context, AnalysisField field, boolean isStore) {
        assert (!Modifier.isStatic(field.getModifiers()));
        FieldTypeStore fieldTypeStore = this.getInstanceFieldTypeStore(bb, context, field);
        return isStore ? fieldTypeStore.writeFlow() : fieldTypeStore.readFlow();
    }

    final FieldTypeStore getInstanceFieldTypeStore(BigBang bb, AnalysisMethod context, AnalysisField field) {
        assert (!Modifier.isStatic(field.getModifiers()));
        assert (bb != null && !bb.getUniverse().sealed());
        if (this.instanceFieldsTypeStore == null) {
            AnalysisField[] fields = this.type.getInstanceFields(true);
            INSTANCE_FIELD_TYPE_STORE_UPDATER.compareAndSet(this, null, new AtomicReferenceArray(fields.length));
        }
        if (field.getPosition() < 0 || field.getPosition() >= this.instanceFieldsTypeStore.length()) {
            throw AnalysisError.fieldNotPresentError(context, field, this.type);
        }
        FieldTypeStore fieldStore = this.instanceFieldsTypeStore.get(field.getPosition());
        if (fieldStore == null) {
            fieldStore = bb.analysisPolicy().createFieldTypeStore(this, field, bb.getUniverse());
            boolean result = this.instanceFieldsTypeStore.compareAndSet(field.getPosition(), null, fieldStore);
            if (result) {
                fieldStore.init(bb);
                field.getInitialInstanceFieldFlow().addUse(bb, fieldStore.writeFlow());
                fieldStore.readFlow().addUse(bb, field.getInstanceFieldFlow());
            } else {
                fieldStore = this.instanceFieldsTypeStore.get(field.getPosition());
            }
        }
        return fieldStore;
    }

    public boolean isEmptyObjectArrayConstant(BigBang bb) {
        return false;
    }

    public boolean isPrimitiveArray() {
        return this.type().isArray() && this.type().getComponentType().getJavaKind() != JavaKind.Object;
    }

    public boolean isObjectArray() {
        return this.type().isArray() && this.type().getComponentType().getJavaKind() == JavaKind.Object;
    }

    public static boolean isEmptyObjectArrayConstant(BigBang bb, JavaConstant constant) {
        Object[] arrayValueObj;
        assert (constant.getJavaKind() == JavaKind.Object);
        Object valueObj = bb.getProviders().getSnippetReflection().asObject(Object.class, constant);
        return valueObj instanceof Object[] && (arrayValueObj = (Object[])valueObj).length == 0;
    }

    public String toString() {
        return String.format("0x%016X", this.id) + ":" + this.kind.prefix + ":" + (this.type != null ? this.type.toJavaName(false) : "");
    }

    @Override
    public int compareTo(AnalysisObject other) {
        return Long.compare(this.getId(), other.getId());
    }

    public final boolean equals(Object other) {
        return this == other;
    }

    public int hashCode() {
        return (int)(this.id & 0xFFFFFFFFFFFFFFFFL);
    }

    protected static enum AnalysisObjectKind {
        ContextInsensitive("!S"),
        AllocationContextSensitive("AS"),
        ConstantContextSensitive("CS");

        protected final String prefix;

        private AnalysisObjectKind(String prefix) {
            this.prefix = prefix;
        }
    }
}

