/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security;

import java.util.Objects;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.client.security.RefreshPolicy;
import org.elasticsearch.core.Nullable;

public final class CreateServiceAccountTokenRequest
implements Validatable {
    private final String namespace;
    private final String serviceName;
    @Nullable
    private final String tokenName;
    @Nullable
    private final RefreshPolicy refreshPolicy;

    public CreateServiceAccountTokenRequest(String namespace, String serviceName, @Nullable String tokenName, @Nullable RefreshPolicy refreshPolicy) {
        this.namespace = Objects.requireNonNull(namespace, "namespace is required");
        this.serviceName = Objects.requireNonNull(serviceName, "service-name is required");
        this.tokenName = tokenName;
        this.refreshPolicy = refreshPolicy;
    }

    public CreateServiceAccountTokenRequest(String namespace, String serviceName, String tokenName) {
        this(namespace, serviceName, tokenName, null);
    }

    public CreateServiceAccountTokenRequest(String namespace, String serviceName) {
        this(namespace, serviceName, null, null);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getTokenName() {
        return this.tokenName;
    }

    public RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateServiceAccountTokenRequest that = (CreateServiceAccountTokenRequest)o;
        return this.namespace.equals(that.namespace) && this.serviceName.equals(that.serviceName) && Objects.equals(this.tokenName, that.tokenName) && this.refreshPolicy == that.refreshPolicy;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.namespace, this.serviceName, this.tokenName, this.refreshPolicy});
    }
}

