/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.watcher;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.client.watcher.WatchStatus;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;

public class GetWatchResponse {
    private final String id;
    private final long version;
    private final long seqNo;
    private final long primaryTerm;
    private final WatchStatus status;
    private final BytesReference source;
    private final XContentType xContentType;
    private static final ParseField ID_FIELD = new ParseField("_id", new String[0]);
    private static final ParseField FOUND_FIELD = new ParseField("found", new String[0]);
    private static final ParseField VERSION_FIELD = new ParseField("_version", new String[0]);
    private static final ParseField SEQ_NO_FIELD = new ParseField("_seq_no", new String[0]);
    private static final ParseField PRIMARY_TERM_FIELD = new ParseField("_primary_term", new String[0]);
    private static final ParseField STATUS_FIELD = new ParseField("status", new String[0]);
    private static final ParseField WATCH_FIELD = new ParseField("watch", new String[0]);
    private static final ConstructingObjectParser<GetWatchResponse, Void> PARSER = new ConstructingObjectParser("get_watch_response", true, a -> {
        boolean isFound = (Boolean)a[1];
        if (isFound) {
            XContentBuilder builder = (XContentBuilder)a[6];
            BytesReference source = BytesReference.bytes((XContentBuilder)builder);
            return new GetWatchResponse((String)a[0], (Long)a[2], (Long)a[3], (Long)a[4], (WatchStatus)a[5], source, builder.contentType());
        }
        return new GetWatchResponse((String)a[0]);
    });

    public GetWatchResponse(String id) {
        this(id, -1L, -2L, 0L, null, null, null);
    }

    public GetWatchResponse(String id, long version, long seqNo, long primaryTerm, WatchStatus status, BytesReference source, XContentType xContentType) {
        this.id = id;
        this.version = version;
        this.status = status;
        this.source = source;
        this.xContentType = xContentType;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
    }

    public String getId() {
        return this.id;
    }

    public long getVersion() {
        return this.version;
    }

    public long getSeqNo() {
        return this.seqNo;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public boolean isFound() {
        return this.version != -1L;
    }

    public WatchStatus getStatus() {
        return this.status;
    }

    public XContentType getContentType() {
        return this.xContentType;
    }

    public BytesReference getSource() {
        return this.source;
    }

    public Map<String, Object> getSourceAsMap() {
        return this.source == null ? null : (Map)XContentHelper.convertToMap((BytesReference)this.source, (boolean)false, (XContentType)this.getContentType()).v2();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetWatchResponse that = (GetWatchResponse)o;
        return this.version == that.version && Objects.equals(this.id, that.id) && Objects.equals(this.status, that.status) && Objects.equals(this.xContentType, that.xContentType) && Objects.equals(this.source, that.source);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.status, this.source, this.version);
    }

    public static GetWatchResponse fromXContent(XContentParser parser) throws IOException {
        return (GetWatchResponse)PARSER.parse(parser, null);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), ID_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), FOUND_FIELD);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), VERSION_FIELD);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), SEQ_NO_FIELD);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), PRIMARY_TERM_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (parser, context) -> WatchStatus.parse(parser), STATUS_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (parser, context) -> {
            try (XContentBuilder builder = XContentBuilder.builder((XContent)parser.contentType().xContent());){
                builder.copyCurrentStructure(parser);
                XContentBuilder xContentBuilder = builder;
                return xContentBuilder;
            }
        }, WATCH_FIELD);
    }
}

