/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.transform.transforms.pivot;

import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class AggregationConfig
implements ToXContentObject {
    private final AggregatorFactories.Builder aggregations;

    public static AggregationConfig fromXContent(XContentParser parser) throws IOException {
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        AggregatorFactories.Builder aggregations = AggregatorFactories.parseAggregators((XContentParser)parser);
        return new AggregationConfig(aggregations);
    }

    public AggregationConfig(AggregatorFactories.Builder aggregations) {
        this.aggregations = aggregations;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.aggregations.toXContent(builder, params);
        return builder;
    }

    public Collection<AggregationBuilder> getAggregatorFactories() {
        return this.aggregations.getAggregatorFactories();
    }

    public int hashCode() {
        return Objects.hash(this.aggregations);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AggregationConfig that = (AggregationConfig)other;
        return Objects.equals(this.aggregations, that.aggregations);
    }
}

