/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.transform;

import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.client.ValidationException;
import org.elasticsearch.core.TimeValue;

public class StartTransformRequest
implements Validatable {
    private final String id;
    private TimeValue timeout;

    public StartTransformRequest(String id) {
        this.id = id;
    }

    public StartTransformRequest(String id, TimeValue timeout) {
        this.id = id;
        this.timeout = timeout;
    }

    public String getId() {
        return this.id;
    }

    public TimeValue getTimeout() {
        return this.timeout;
    }

    public void setTimeout(TimeValue timeout) {
        this.timeout = timeout;
    }

    @Override
    public Optional<ValidationException> validate() {
        if (this.id == null) {
            ValidationException validationException = new ValidationException();
            validationException.addValidationError("transform id must not be null");
            return Optional.of(validationException);
        }
        return Optional.empty();
    }

    public int hashCode() {
        return Objects.hash(this.id, this.timeout);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StartTransformRequest other = (StartTransformRequest)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.timeout, other.timeout);
    }
}

