/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.transform;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.client.ValidationException;
import org.elasticsearch.client.core.PageParams;

public class GetTransformRequest
implements Validatable {
    public static final String EXCLUDE_GENERATED = "exclude_generated";
    public static final String ALLOW_NO_MATCH = "allow_no_match";
    private final List<String> ids;
    private PageParams pageParams;
    private Boolean allowNoMatch;
    private Boolean excludeGenerated;

    public static GetTransformRequest getAllTransformRequest() {
        return new GetTransformRequest("_all");
    }

    public GetTransformRequest(String ... ids) {
        this.ids = Arrays.asList(ids);
    }

    public List<String> getId() {
        return this.ids;
    }

    public PageParams getPageParams() {
        return this.pageParams;
    }

    public void setPageParams(PageParams pageParams) {
        this.pageParams = pageParams;
    }

    public Boolean getAllowNoMatch() {
        return this.allowNoMatch;
    }

    public void setAllowNoMatch(Boolean allowNoMatch) {
        this.allowNoMatch = allowNoMatch;
    }

    public void setExcludeGenerated(boolean excludeGenerated) {
        this.excludeGenerated = excludeGenerated;
    }

    public Boolean getExcludeGenerated() {
        return this.excludeGenerated;
    }

    @Override
    public Optional<ValidationException> validate() {
        if (this.ids == null || this.ids.isEmpty()) {
            ValidationException validationException = new ValidationException();
            validationException.addValidationError("transform id must not be null");
            return Optional.of(validationException);
        }
        return Optional.empty();
    }

    public int hashCode() {
        return Objects.hash(this.ids, this.pageParams, this.excludeGenerated, this.allowNoMatch);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GetTransformRequest other = (GetTransformRequest)obj;
        return Objects.equals(this.ids, other.ids) && Objects.equals(this.pageParams, other.pageParams) && Objects.equals(this.excludeGenerated, other.excludeGenerated) && Objects.equals(this.allowNoMatch, other.allowNoMatch);
    }
}

