/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.dataframe;

import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.client.common.TimeUtil;
import org.elasticsearch.client.ml.dataframe.DataFrameAnalysis;
import org.elasticsearch.client.ml.dataframe.DataFrameAnalyticsDest;
import org.elasticsearch.client.ml.dataframe.DataFrameAnalyticsSource;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class DataFrameAnalyticsConfig
implements ToXContentObject {
    static final ParseField ID = new ParseField("id", new String[0]);
    static final ParseField DESCRIPTION = new ParseField("description", new String[0]);
    static final ParseField SOURCE = new ParseField("source", new String[0]);
    static final ParseField DEST = new ParseField("dest", new String[0]);
    static final ParseField ANALYSIS = new ParseField("analysis", new String[0]);
    static final ParseField ANALYZED_FIELDS = new ParseField("analyzed_fields", new String[0]);
    static final ParseField MODEL_MEMORY_LIMIT = new ParseField("model_memory_limit", new String[0]);
    static final ParseField CREATE_TIME = new ParseField("create_time", new String[0]);
    static final ParseField VERSION = new ParseField("version", new String[0]);
    static final ParseField ALLOW_LAZY_START = new ParseField("allow_lazy_start", new String[0]);
    static final ParseField MAX_NUM_THREADS = new ParseField("max_num_threads", new String[0]);
    private static final ObjectParser<Builder, Void> PARSER = new ObjectParser("data_frame_analytics_config", true, () -> new Builder());
    private final String id;
    private final String description;
    private final DataFrameAnalyticsSource source;
    private final DataFrameAnalyticsDest dest;
    private final DataFrameAnalysis analysis;
    private final FetchSourceContext analyzedFields;
    private final ByteSizeValue modelMemoryLimit;
    private final Instant createTime;
    private final Version version;
    private final Boolean allowLazyStart;
    private final Integer maxNumThreads;

    public static DataFrameAnalyticsConfig fromXContent(XContentParser parser) {
        return ((Builder)PARSER.apply(parser, null)).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static DataFrameAnalysis parseAnalysis(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        DataFrameAnalysis analysis = (DataFrameAnalysis)parser.namedObject(DataFrameAnalysis.class, parser.currentName(), (Object)true);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        return analysis;
    }

    private DataFrameAnalyticsConfig(@Nullable String id, @Nullable String description, @Nullable DataFrameAnalyticsSource source, @Nullable DataFrameAnalyticsDest dest, @Nullable DataFrameAnalysis analysis, @Nullable FetchSourceContext analyzedFields, @Nullable ByteSizeValue modelMemoryLimit, @Nullable Instant createTime, @Nullable Version version, @Nullable Boolean allowLazyStart, @Nullable Integer maxNumThreads) {
        this.id = id;
        this.description = description;
        this.source = source;
        this.dest = dest;
        this.analysis = analysis;
        this.analyzedFields = analyzedFields;
        this.modelMemoryLimit = modelMemoryLimit;
        this.createTime = createTime == null ? null : Instant.ofEpochMilli(createTime.toEpochMilli());
        this.version = version;
        this.allowLazyStart = allowLazyStart;
        this.maxNumThreads = maxNumThreads;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public DataFrameAnalyticsSource getSource() {
        return this.source;
    }

    public DataFrameAnalyticsDest getDest() {
        return this.dest;
    }

    public DataFrameAnalysis getAnalysis() {
        return this.analysis;
    }

    public FetchSourceContext getAnalyzedFields() {
        return this.analyzedFields;
    }

    public ByteSizeValue getModelMemoryLimit() {
        return this.modelMemoryLimit;
    }

    public Instant getCreateTime() {
        return this.createTime;
    }

    public Version getVersion() {
        return this.version;
    }

    public Boolean getAllowLazyStart() {
        return this.allowLazyStart;
    }

    public Integer getMaxNumThreads() {
        return this.maxNumThreads;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.id != null) {
            builder.field(ID.getPreferredName(), this.id);
        }
        if (this.description != null) {
            builder.field(DESCRIPTION.getPreferredName(), this.description);
        }
        if (this.source != null) {
            builder.field(SOURCE.getPreferredName(), (ToXContent)this.source);
        }
        if (this.dest != null) {
            builder.field(DEST.getPreferredName(), (ToXContent)this.dest);
        }
        if (this.analysis != null) {
            builder.startObject(ANALYSIS.getPreferredName()).field(this.analysis.getName(), (ToXContent)this.analysis).endObject();
        }
        if (this.analyzedFields != null) {
            builder.field(ANALYZED_FIELDS.getPreferredName(), (ToXContent)this.analyzedFields);
        }
        if (this.modelMemoryLimit != null) {
            builder.field(MODEL_MEMORY_LIMIT.getPreferredName(), this.modelMemoryLimit.getStringRep());
        }
        if (this.createTime != null) {
            builder.timeField(CREATE_TIME.getPreferredName(), CREATE_TIME.getPreferredName() + "_string", this.createTime.toEpochMilli());
        }
        if (this.version != null) {
            builder.field(VERSION.getPreferredName(), (ToXContent)this.version);
        }
        if (this.allowLazyStart != null) {
            builder.field(ALLOW_LAZY_START.getPreferredName(), this.allowLazyStart);
        }
        if (this.maxNumThreads != null) {
            builder.field(MAX_NUM_THREADS.getPreferredName(), this.maxNumThreads);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataFrameAnalyticsConfig other = (DataFrameAnalyticsConfig)o;
        return Objects.equals(this.id, other.id) && Objects.equals(this.description, other.description) && Objects.equals(this.source, other.source) && Objects.equals(this.dest, other.dest) && Objects.equals(this.analysis, other.analysis) && Objects.equals(this.analyzedFields, other.analyzedFields) && Objects.equals(this.modelMemoryLimit, other.modelMemoryLimit) && Objects.equals(this.createTime, other.createTime) && Objects.equals(this.version, other.version) && Objects.equals(this.allowLazyStart, other.allowLazyStart) && Objects.equals(this.maxNumThreads, other.maxNumThreads);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.description, this.source, this.dest, this.analysis, this.analyzedFields, this.modelMemoryLimit, this.createTime, this.version, this.allowLazyStart, this.maxNumThreads);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        PARSER.declareString(Builder::setId, ID);
        PARSER.declareString(Builder::setDescription, DESCRIPTION);
        PARSER.declareObject(Builder::setSource, (p, c) -> DataFrameAnalyticsSource.fromXContent(p), SOURCE);
        PARSER.declareObject(Builder::setDest, (p, c) -> DataFrameAnalyticsDest.fromXContent(p), DEST);
        PARSER.declareObject(Builder::setAnalysis, (p, c) -> DataFrameAnalyticsConfig.parseAnalysis(p), ANALYSIS);
        PARSER.declareField(Builder::setAnalyzedFields, (p, c) -> FetchSourceContext.fromXContent((XContentParser)p), ANALYZED_FIELDS, ObjectParser.ValueType.OBJECT_ARRAY_BOOLEAN_OR_STRING);
        PARSER.declareField(Builder::setModelMemoryLimit, (p, c) -> ByteSizeValue.parseBytesSizeValue((String)p.text(), (String)MODEL_MEMORY_LIMIT.getPreferredName()), MODEL_MEMORY_LIMIT, ObjectParser.ValueType.VALUE);
        PARSER.declareField(Builder::setCreateTime, p -> TimeUtil.parseTimeFieldToInstant(p, CREATE_TIME.getPreferredName()), CREATE_TIME, ObjectParser.ValueType.VALUE);
        PARSER.declareString(Builder::setVersion, Version::fromString, VERSION);
        PARSER.declareBoolean(Builder::setAllowLazyStart, ALLOW_LAZY_START);
        PARSER.declareInt(Builder::setMaxNumThreads, MAX_NUM_THREADS);
    }

    public static class Builder {
        private String id;
        private String description;
        private DataFrameAnalyticsSource source;
        private DataFrameAnalyticsDest dest;
        private DataFrameAnalysis analysis;
        private FetchSourceContext analyzedFields;
        private ByteSizeValue modelMemoryLimit;
        private Instant createTime;
        private Version version;
        private Boolean allowLazyStart;
        private Integer maxNumThreads;

        private Builder() {
        }

        public Builder setId(String id) {
            this.id = Objects.requireNonNull(id);
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setSource(DataFrameAnalyticsSource source) {
            this.source = Objects.requireNonNull(source);
            return this;
        }

        public Builder setDest(DataFrameAnalyticsDest dest) {
            this.dest = Objects.requireNonNull(dest);
            return this;
        }

        public Builder setAnalysis(DataFrameAnalysis analysis) {
            this.analysis = Objects.requireNonNull(analysis);
            return this;
        }

        public Builder setAnalyzedFields(FetchSourceContext fields) {
            this.analyzedFields = fields;
            return this;
        }

        public Builder setModelMemoryLimit(ByteSizeValue modelMemoryLimit) {
            this.modelMemoryLimit = modelMemoryLimit;
            return this;
        }

        Builder setCreateTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        Builder setVersion(Version version) {
            this.version = version;
            return this;
        }

        public Builder setAllowLazyStart(Boolean allowLazyStart) {
            this.allowLazyStart = allowLazyStart;
            return this;
        }

        public Builder setMaxNumThreads(Integer maxNumThreads) {
            this.maxNumThreads = maxNumThreads;
            return this;
        }

        public DataFrameAnalyticsConfig build() {
            return new DataFrameAnalyticsConfig(this.id, this.description, this.source, this.dest, this.analysis, this.analyzedFields, this.modelMemoryLimit, this.createTime, this.version, this.allowLazyStart, this.maxNumThreads);
        }
    }
}

