/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.client.ml.datafeed.DatafeedConfig;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class GetDatafeedStatsRequest
extends ActionRequest
implements ToXContentObject {
    public static final ParseField ALLOW_NO_MATCH = new ParseField("allow_no_match", new String[0]);
    public static final ConstructingObjectParser<GetDatafeedStatsRequest, Void> PARSER = new ConstructingObjectParser("get_datafeed_stats_request", a -> new GetDatafeedStatsRequest((List)a[0]));
    private static final String ALL_DATAFEEDS = "_all";
    private final List<String> datafeedIds;
    private Boolean allowNoMatch;

    public static GetDatafeedStatsRequest getAllDatafeedStatsRequest() {
        return new GetDatafeedStatsRequest(ALL_DATAFEEDS);
    }

    GetDatafeedStatsRequest(List<String> datafeedIds) {
        if (datafeedIds.stream().anyMatch(Objects::isNull)) {
            throw new NullPointerException("datafeedIds must not contain null values");
        }
        this.datafeedIds = new ArrayList<String>(datafeedIds);
    }

    public GetDatafeedStatsRequest(String ... datafeedIds) {
        this(Arrays.asList(datafeedIds));
    }

    public List<String> getDatafeedIds() {
        return this.datafeedIds;
    }

    public Boolean getAllowNoMatch() {
        return this.allowNoMatch;
    }

    public void setAllowNoMatch(boolean allowNoMatch) {
        this.allowNoMatch = allowNoMatch;
    }

    public int hashCode() {
        return Objects.hash(this.datafeedIds, this.allowNoMatch);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || ((Object)((Object)this)).getClass() != other.getClass()) {
            return false;
        }
        GetDatafeedStatsRequest that = (GetDatafeedStatsRequest)((Object)other);
        return Objects.equals(this.datafeedIds, that.datafeedIds) && Objects.equals(this.allowNoMatch, that.allowNoMatch);
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(DatafeedConfig.ID.getPreferredName(), Strings.collectionToCommaDelimitedString(this.datafeedIds));
        if (this.allowNoMatch != null) {
            builder.field(ALLOW_NO_MATCH.getPreferredName(), this.allowNoMatch);
        }
        builder.endObject();
        return builder;
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> Arrays.asList(Strings.commaDelimitedListToStringArray((String)p.text())), DatafeedConfig.ID, ObjectParser.ValueType.STRING_ARRAY);
        PARSER.declareBoolean(GetDatafeedStatsRequest::setAllowNoMatch, ALLOW_NO_MATCH);
    }
}

