/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="Jetty Handler")
public abstract class AbstractHandler
extends ContainerLifeCycle
implements Handler {
    private static final Logger LOG = Log.getLogger(AbstractHandler.class);
    private Server _server;

    @Override
    protected void doStart() throws Exception {
        LOG.debug("starting {}", this);
        if (this._server == null) {
            LOG.warn("No Server set for {}", this);
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        LOG.debug("stopping {}", this);
        super.doStop();
    }

    @Override
    public void setServer(Server server) {
        if (this._server == server) {
            return;
        }
        if (this.isStarted()) {
            throw new IllegalStateException("STARTED");
        }
        this._server = server;
    }

    @Override
    public Server getServer() {
        return this._server;
    }

    @Override
    public void destroy() {
        if (!this.isStopped()) {
            throw new IllegalStateException("!STOPPED");
        }
        super.destroy();
    }

    @Override
    public void dumpThis(Appendable out) throws IOException {
        out.append(this.toString()).append(" - ").append(this.getState()).append('\n');
    }
}

