/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.transform;

import java.util.Random;
import org.bytedeco.javacv.OpenCVFrameConverter;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Size;
import org.datavec.image.data.ImageWritable;
import org.datavec.image.transform.BaseImageTransform;
import org.nd4j.shade.jackson.annotation.JsonInclude;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ResizeImageTransform
extends BaseImageTransform<Mat> {
    private int newHeight;
    private int newWidth;
    private int srch;
    private int srcw;

    public ResizeImageTransform(@JsonProperty(value="newWidth") int newWidth, @JsonProperty(value="newHeight") int newHeight) {
        this(null, newWidth, newHeight);
    }

    public ResizeImageTransform(Random random, int newWidth, int newHeight) {
        super(random);
        this.newWidth = newWidth;
        this.newHeight = newHeight;
        this.converter = new OpenCVFrameConverter.ToMat();
    }

    @Override
    protected ImageWritable doTransform(ImageWritable image, Random random) {
        if (image == null) {
            return null;
        }
        Mat mat = (Mat)this.converter.convert(image.getFrame());
        Mat result = new Mat();
        this.srch = mat.rows();
        this.srcw = mat.cols();
        opencv_imgproc.resize((Mat)mat, (Mat)result, (Size)new Size(this.newWidth, this.newHeight));
        return new ImageWritable(this.converter.convert((Object)result));
    }

    @Override
    public float[] query(float ... coordinates) {
        float[] transformed = new float[coordinates.length];
        for (int i = 0; i < coordinates.length; i += 2) {
            transformed[i] = (float)this.newWidth * coordinates[i] / (float)this.srcw;
            transformed[i + 1] = (float)this.newHeight * coordinates[i + 1] / (float)this.srch;
        }
        return transformed;
    }

    public int getNewHeight() {
        return this.newHeight;
    }

    public int getNewWidth() {
        return this.newWidth;
    }

    public int getSrch() {
        return this.srch;
    }

    public int getSrcw() {
        return this.srcw;
    }

    public void setNewHeight(int newHeight) {
        this.newHeight = newHeight;
    }

    public void setNewWidth(int newWidth) {
        this.newWidth = newWidth;
    }

    public void setSrch(int srch) {
        this.srch = srch;
    }

    public void setSrcw(int srcw) {
        this.srcw = srcw;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResizeImageTransform)) {
            return false;
        }
        ResizeImageTransform other = (ResizeImageTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getNewHeight() != other.getNewHeight()) {
            return false;
        }
        if (this.getNewWidth() != other.getNewWidth()) {
            return false;
        }
        if (this.getSrch() != other.getSrch()) {
            return false;
        }
        return this.getSrcw() == other.getSrcw();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ResizeImageTransform;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getNewHeight();
        result = result * 59 + this.getNewWidth();
        result = result * 59 + this.getSrch();
        result = result * 59 + this.getSrcw();
        return result;
    }

    @Override
    public String toString() {
        return "ResizeImageTransform(newHeight=" + this.getNewHeight() + ", newWidth=" + this.getNewWidth() + ", srch=" + this.getSrch() + ", srcw=" + this.getSrcw() + ")";
    }
}

