/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.writable;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.datavec.api.io.WritableComparable;
import org.datavec.api.io.WritableComparator;
import org.datavec.api.writable.ByteWritable;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.FloatWritable;
import org.datavec.api.writable.IntWritable;
import org.datavec.api.writable.Writable;
import org.datavec.api.writable.WritableType;
import org.nd4j.shade.guava.math.DoubleMath;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class LongWritable
implements WritableComparable {
    private long value;

    public LongWritable() {
    }

    public LongWritable(@JsonProperty(value="value") long value) {
        this.set(value);
    }

    public void set(long value) {
        this.value = value;
    }

    public long get() {
        return this.value;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.value = in.readLong();
    }

    @Override
    public void writeType(DataOutput out) throws IOException {
        out.writeShort(WritableType.Long.typeIdx());
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeLong(this.value);
    }

    public boolean fuzzyEquals(Writable o, double tolerance) {
        double other;
        if (o instanceof IntWritable) {
            other = ((IntWritable)o).toDouble();
        } else if (o instanceof LongWritable) {
            other = ((LongWritable)o).toDouble();
        } else if (o instanceof ByteWritable) {
            other = ((ByteWritable)o).toDouble();
        } else if (o instanceof DoubleWritable) {
            other = ((DoubleWritable)o).toDouble();
        } else if (o instanceof FloatWritable) {
            other = ((FloatWritable)o).toDouble();
        } else {
            return false;
        }
        return DoubleMath.fuzzyEquals((double)this.value, (double)other, (double)tolerance);
    }

    public boolean equals(Object o) {
        if (o instanceof ByteWritable) {
            ByteWritable other = (ByteWritable)o;
            return this.value == (long)other.get();
        }
        if (o instanceof LongWritable) {
            LongWritable other = (LongWritable)o;
            return this.value == other.get();
        }
        if (o instanceof IntWritable) {
            IntWritable other = (IntWritable)o;
            return this.value == (long)other.get();
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    @Override
    public int compareTo(Object o) {
        long thisValue = this.value;
        long thatValue = ((LongWritable)o).value;
        return thisValue < thatValue ? -1 : (thisValue == thatValue ? 0 : 1);
    }

    public String toString() {
        return Long.toString(this.value);
    }

    @Override
    public double toDouble() {
        return this.value;
    }

    @Override
    public float toFloat() {
        return this.value;
    }

    @Override
    public int toInt() {
        return (int)this.value;
    }

    @Override
    public long toLong() {
        return this.value;
    }

    @Override
    public WritableType getType() {
        return WritableType.Long;
    }

    static {
        WritableComparator.define(LongWritable.class, new Comparator());
    }

    public static class DecreasingComparator
    extends Comparator {
        @Override
        public int compare(WritableComparable a, WritableComparable b) {
            return -super.compare(a, b);
        }

        @Override
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            return -super.compare(b1, s1, l1, b2, s2, l2);
        }
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(LongWritable.class);
        }

        @Override
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            long thatValue;
            long thisValue = Comparator.readLong(b1, s1);
            return thisValue < (thatValue = Comparator.readLong(b2, s2)) ? -1 : (thisValue == thatValue ? 0 : 1);
        }
    }
}

