/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchComponent;
import org.sonar.api.ServerComponent;
import org.sonar.api.config.Settings;
import org.sonar.api.platform.Server;
import org.sonar.api.utils.ProxyAuthenticator;
import org.sonar.api.utils.SonarException;
import org.sonar.api.utils.UriReader;

public class HttpDownloader
extends UriReader.SchemeProcessor
implements BatchComponent,
ServerComponent {
    public static final int TIMEOUT_MILLISECONDS = 20000;
    private static final List<String> PROXY_SETTINGS = ImmutableList.of((Object)"http.proxyHost", (Object)"http.proxyPort", (Object)"http.nonProxyHosts", (Object)"http.auth.ntlm.domain", (Object)"socksProxyHost", (Object)"socksProxyPort");
    private String userAgent;

    public HttpDownloader(Server server, Settings settings) {
        this(settings, server.getVersion());
    }

    public HttpDownloader(Settings settings) {
        this(settings, null);
    }

    private HttpDownloader(Settings settings, String userAgent) {
        this.initProxy(settings);
        this.initUserAgent(userAgent);
    }

    private void initProxy(Settings settings) {
        this.propagateProxySystemProperties(settings);
        if (this.requiresProxyAuthentication(settings)) {
            this.registerProxyCredentials(settings);
        }
    }

    private void initUserAgent(String sonarVersion) {
        this.userAgent = sonarVersion == null ? "Sonar" : String.format("Sonar %s", sonarVersion);
        System.setProperty("http.agent", this.userAgent);
    }

    public String getProxySynthesis(URI uri) {
        return HttpDownloader.getProxySynthesis(uri, ProxySelector.getDefault());
    }

    @VisibleForTesting
    static String getProxySynthesis(URI uri, ProxySelector proxySelector) {
        List<Proxy> proxies = proxySelector.select(uri);
        if (proxies.size() == 1 && proxies.get(0).type().equals((Object)Proxy.Type.DIRECT)) {
            return "no proxy";
        }
        ArrayList descriptions = Lists.newArrayList();
        for (Proxy proxy : proxies) {
            if (proxy.type() == Proxy.Type.DIRECT) continue;
            descriptions.add("proxy: " + proxy.address());
        }
        return Joiner.on((String)", ").join((Iterable)descriptions);
    }

    private void registerProxyCredentials(Settings settings) {
        Authenticator.setDefault(new ProxyAuthenticator(settings.getString("http.proxyUser"), settings.getString("http.proxyPassword")));
    }

    private boolean requiresProxyAuthentication(Settings settings) {
        return settings.getString("http.proxyUser") != null;
    }

    private void propagateProxySystemProperties(Settings settings) {
        for (String key : PROXY_SETTINGS) {
            if (settings.getString(key) == null) continue;
            System.setProperty(key, settings.getString(key));
        }
    }

    String description(URI uri) {
        return String.format("%s (%s)", uri.toString(), this.getProxySynthesis(uri));
    }

    String[] getSupportedSchemes() {
        return new String[]{"http", "https"};
    }

    byte[] readBytes(URI uri) {
        try {
            return ByteStreams.toByteArray((InputSupplier)new HttpInputSupplier(uri));
        }
        catch (IOException e) {
            throw this.failToDownload(uri, e);
        }
    }

    String readString(URI uri, Charset charset) {
        try {
            return CharStreams.toString((InputSupplier)CharStreams.newReaderSupplier((InputSupplier)new HttpInputSupplier(uri), (Charset)charset));
        }
        catch (IOException e) {
            throw this.failToDownload(uri, e);
        }
    }

    public byte[] download(URI uri) {
        return this.readBytes(uri);
    }

    public String downloadPlainText(URI uri, String encoding) {
        return this.readString(uri, Charset.forName(encoding));
    }

    public InputStream openStream(URI uri) {
        try {
            return new HttpInputSupplier(uri).getInput();
        }
        catch (Exception e) {
            throw new SonarException("Fail to download the file: " + uri + " (" + this.getProxySynthesis(uri) + ")", e);
        }
    }

    public void download(URI uri, File toFile) {
        try {
            Files.copy((InputSupplier)new HttpInputSupplier(uri), (File)toFile);
        }
        catch (IOException e) {
            FileUtils.deleteQuietly((File)toFile);
            throw this.failToDownload(uri, e);
        }
    }

    private SonarException failToDownload(URI uri, IOException e) {
        return new SonarException(String.format("Fail to download the file: %s (%s)", uri, this.getProxySynthesis(uri)), e);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class HttpInputSupplier
    implements InputSupplier<InputStream> {
        private final URI uri;

        HttpInputSupplier(URI uri) {
            this.uri = uri;
        }

        public InputStream getInput() throws IOException {
            LoggerFactory.getLogger(this.getClass()).debug("Download: " + this.uri + " (" + HttpDownloader.this.getProxySynthesis(this.uri) + ")");
            HttpURLConnection connection = (HttpURLConnection)this.uri.toURL().openConnection();
            connection.setConnectTimeout(20000);
            connection.setReadTimeout(20000);
            connection.setUseCaches(true);
            connection.setInstanceFollowRedirects(true);
            connection.setRequestProperty("User-Agent", HttpDownloader.this.userAgent);
            return connection.getInputStream();
        }
    }
}

