/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.qualitymodel;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.sonar.api.qualitymodel.Characteristic;

@Entity
@Table(name="characteristic_properties")
public final class CharacteristicProperty {
    @Id
    @Column(name="id")
    @GeneratedValue
    private Integer id;
    @Column(name="kee", nullable=true, length=100)
    private String key;
    @Column(name="value", nullable=true)
    private Double value;
    @Column(name="text_value", nullable=true, length=4000)
    private String textValue;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="characteristic_id", updatable=true, nullable=false)
    private Characteristic characteristic;

    CharacteristicProperty() {
    }

    public static CharacteristicProperty create(String key) {
        return new CharacteristicProperty().setKey(key);
    }

    public Integer getId() {
        return this.id;
    }

    CharacteristicProperty setId(Integer i) {
        this.id = i;
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public CharacteristicProperty setKey(String s) {
        this.key = s;
        return this;
    }

    public String getTextValue() {
        return this.textValue;
    }

    public Double getValue() {
        return this.value;
    }

    public Long getValueAsLong() {
        if (this.value != null) {
            return this.value.longValue();
        }
        return null;
    }

    public CharacteristicProperty setTextValue(String s) {
        this.textValue = s;
        return this;
    }

    public CharacteristicProperty setValue(Double d) {
        this.value = d;
        return this;
    }

    Characteristic getCharacteristic() {
        return this.characteristic;
    }

    CharacteristicProperty setCharacteristic(Characteristic c) {
        this.characteristic = c;
        return this;
    }
}

