/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.internal.pmd;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.List;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokenizer;
import net.sourceforge.pmd.cpd.Tokens;
import org.sonar.duplications.block.Block;
import org.sonar.duplications.cpd.FileCodeLoaderWithoutCache;
import org.sonar.duplications.internal.pmd.PmdBlockChunker;
import org.sonar.duplications.internal.pmd.TokensLine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenizerBridge {
    private final Tokenizer tokenizer;
    private final String encoding;
    private final PmdBlockChunker blockBuilder;

    public TokenizerBridge(Tokenizer tokenizer, String encoding, int blockSize) {
        this.tokenizer = tokenizer;
        this.encoding = encoding;
        this.blockBuilder = new PmdBlockChunker(blockSize);
    }

    public List<Block> chunk(String resourceId, File file) {
        return this.blockBuilder.chunk(resourceId, this.chunk(file));
    }

    public List<TokensLine> chunk(File file) {
        SourceCode sourceCode = new SourceCode(new FileCodeLoaderWithoutCache(file, this.encoding));
        Tokens tokens = new Tokens();
        TokenEntry.clearImages();
        try {
            this.tokenizer.tokenize(sourceCode, tokens);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        TokenEntry.clearImages();
        return TokenizerBridge.convert(tokens.getTokens());
    }

    private static List<TokensLine> convert(List<TokenEntry> tokens) {
        ImmutableList.Builder result = ImmutableList.builder();
        StringBuilder sb = new StringBuilder();
        int startLine = Integer.MIN_VALUE;
        int startIndex = 0;
        int currentIndex = 0;
        for (TokenEntry token : tokens) {
            if (token == TokenEntry.EOF) continue;
            String value = token.getValue();
            int line = token.getBeginLine();
            if (line != startLine) {
                TokenizerBridge.addNewTokensLine((ImmutableList.Builder<TokensLine>)result, startIndex, currentIndex, startLine, sb);
                startIndex = currentIndex + 1;
                startLine = line;
            }
            ++currentIndex;
            sb.append(value);
        }
        TokenizerBridge.addNewTokensLine((ImmutableList.Builder<TokensLine>)result, startIndex, currentIndex, startLine, sb);
        return result.build();
    }

    private static void addNewTokensLine(ImmutableList.Builder<TokensLine> result, int startUnit, int endUnit, int startLine, StringBuilder sb) {
        if (sb.length() != 0) {
            result.add((Object)new TokensLine(startUnit, endUnit, startLine, sb.toString()));
            sb.setLength(0);
        }
    }
}

