/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.runner.impl;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Properties;
import org.sonar.runner.impl.IsolatedClassloader;
import org.sonar.runner.impl.JarDownloader;
import org.sonar.runner.impl.RunnerException;
import org.sonar.runner.impl.ServerConnection;
import org.sonar.runner.impl.ServerVersion;
import org.sonar.runner.impl.TempCleaning;

public class BatchLauncher {
    final String isolatedLauncherClass;
    private final TempCleaning tempCleaning;

    BatchLauncher(String isolatedLauncherClass, TempCleaning tempCleaning) {
        this.isolatedLauncherClass = isolatedLauncherClass;
        this.tempCleaning = tempCleaning;
    }

    public BatchLauncher() {
        this("org.sonar.runner.batch.IsolatedLauncher", new TempCleaning());
    }

    public void execute(Properties props, List<Object> extensions) {
        ServerConnection serverConnection = ServerConnection.create(props);
        ServerVersion serverVersion = new ServerVersion(serverConnection);
        JarDownloader jarDownloader = new JarDownloader(props, serverConnection, serverVersion);
        this.doExecute(jarDownloader, serverVersion, props, extensions);
    }

    private static String[][] getMaskRules(Properties props) {
        String maskRulesProp = props.getProperty("sonarRunner.maskRules", null);
        String[] maskRulesConcat = maskRulesProp != null ? maskRulesProp.split(",") : new String[]{};
        String[][] maskRules = new String[maskRulesConcat.length][2];
        for (int i = 0; i < maskRulesConcat.length; ++i) {
            String[] splitted = maskRulesConcat[i].split("\\|");
            maskRules[i][0] = splitted[0];
            maskRules[i][1] = splitted.length > 1 ? splitted[1] : "";
        }
        return maskRules;
    }

    Object doExecute(final JarDownloader jarDownloader, final ServerVersion serverVersion, final Properties props, final List<Object> extensions) {
        Object launcher = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                List<File> jarFiles = jarDownloader.download();
                String[][] maskRules = BatchLauncher.getMaskRules(props);
                IsolatedClassloader classloader = new IsolatedClassloader(this.getClass().getClassLoader(), maskRules);
                classloader.addFiles(jarFiles);
                Object launcher = this.delegateExecution(classloader, serverVersion.version(), props, extensions);
                BatchLauncher.this.tempCleaning.clean();
                return launcher;
            }

            private Object delegateExecution(IsolatedClassloader classloader, String sonarVersion, Properties properties, List<Object> extensions2) {
                ClassLoader initialContextClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(classloader);
                    Class<?> launcherClass = classloader.loadClass(BatchLauncher.this.isolatedLauncherClass);
                    Method executeMethod = launcherClass.getMethod("execute", String.class, Properties.class, List.class);
                    Object launcher = launcherClass.newInstance();
                    executeMethod.invoke(launcher, sonarVersion, properties, extensions2);
                    Object obj = launcher;
                    return obj;
                }
                catch (InvocationTargetException e) {
                    throw new RunnerException("Unable to execute Sonar", e.getTargetException());
                }
                catch (Exception e) {
                    throw new RunnerException("Unable to execute Sonar", e);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(initialContextClassLoader);
                }
            }
        });
        return launcher;
    }
}

