/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.was6;

import java.io.File;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.was6.AbstractWas6Mojo;
import org.dom4j.Document;

public class Wsdl2java
extends AbstractWas6Mojo {
    private File wsdlFile;
    private File output;
    private Boolean generateHashCodeEquals;
    private String container;
    private String deployScope;
    private Boolean generateResolver;
    private Boolean implementSerializable;
    private String generateJavaCode;
    private String generateXml;
    private File inputMappingFile;
    private Boolean noDataBinding;
    private Boolean doNotWrapArrays;
    private Boolean doNotWrapOperations;
    private File nsToPkgMappingFile;
    private String scenario;
    private String role;
    private List includes;
    private List excludes;
    private boolean useFiltering;

    protected void configureBuildScript(Document document) throws MojoExecutionException {
        try {
            this.configureTaskAttribute(document, "url", this.wsdlFile.toURL());
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        this.configureTaskAttribute(document, "genEquals", this.generateHashCodeEquals);
        this.configureTaskAttribute(document, "container", this.container);
        this.configureTaskAttribute(document, "deployScope", this.deployScope);
        this.configureTaskAttribute(document, "generateResolver", this.generateResolver);
        this.configureTaskAttribute(document, "genImplSer", this.implementSerializable);
        this.configureTaskAttribute(document, "genJava", this.generateJavaCode);
        this.configureTaskAttribute(document, "genXML", this.generateXml);
        this.configureTaskAttribute(document, "inputMappingFile", this.inputMappingFile);
        this.configureTaskAttribute(document, "noDataBinding", this.noDataBinding);
        this.configureTaskAttribute(document, "noWrappedArrays", this.doNotWrapArrays);
        this.configureTaskAttribute(document, "fileNStoPkg", this.nsToPkgMappingFile);
        this.configureTaskAttribute(document, "scenario", this.scenario);
        this.configureTaskAttribute(document, "noWrappedOperations", this.doNotWrapOperations);
        this.configureTaskAttribute(document, "role", this.role);
        this.configureTaskAttribute(document, "output", this.output);
        this.configureTaskAttribute(document, "classpath", this.getRuntimeClasspath());
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        this.addResources();
    }

    private void addResources() throws MojoExecutionException, MojoFailureException {
        Resource resource = new Resource();
        resource.setExcludes(this.excludes);
        resource.setIncludes(this.includes);
        resource.setDirectory(this.output.getAbsolutePath());
        resource.setFiltering(this.useFiltering);
        this.getLog().debug((CharSequence)("Adding resource: " + resource));
        this.getMavenProject().getResources().add(resource);
    }

    private String getRuntimeClasspath() throws MojoExecutionException {
        try {
            HashSet dependencySet = new HashSet();
            dependencySet.addAll(this.getMavenProject().getCompileClasspathElements());
            dependencySet.addAll(this.getMavenProject().getRuntimeClasspathElements());
            String compileClasspath = StringUtils.join(dependencySet, (String)File.pathSeparator);
            return compileClasspath;
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    protected String getTaskName() {
        return "wsdl2java";
    }
}

