/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.was6;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.was6.AbstractEjbMojo;
import org.dom4j.Document;

public class EjbDeployMojo
extends AbstractEjbMojo {
    private MavenProject executedProject;
    private boolean noValidate;
    private boolean noWarnings;
    private boolean noInform;
    private boolean legacyMode;
    private String dbname;
    private String dbschema;
    private String dbvendor;
    private boolean dynamic;
    private boolean compatible35;
    private boolean sqlj;
    private String jdkComplianceLevel;

    protected File getOutputJarFile() {
        File outputJarFile = new File(this.getWorkingDirectory(), this.executedProject.getArtifact().getArtifactId() + "-deployed.jar");
        return outputJarFile;
    }

    protected String getTaskName() {
        return "wsEjbDeploy";
    }

    protected void configureBuildScript(Document document) throws MojoExecutionException {
        document.getRootElement().addElement("property").addAttribute("name", "user.install.root").addAttribute("location", this.getWasHome().getAbsolutePath());
        File inputFile = this.executedProject.getArtifact().getFile();
        if (!inputFile.canRead()) {
            throw new MojoExecutionException("Invalid archive: " + inputFile.getAbsolutePath());
        }
        this.configureTaskAttribute(document, "inputJar", inputFile.getAbsolutePath());
        this.configureTaskAttribute(document, "outputJar", this.getOutputJarFile());
        this.configureTaskAttribute(document, "workingDirectory", this.getWorkingDirectory().getAbsolutePath());
        this.configureTaskAttribute(document, "trace", Boolean.toString(this.isVerbose()));
        this.configureTaskAttribute(document, "noInform", Boolean.toString(this.noInform));
        this.configureTaskAttribute(document, "noWarnings", Boolean.toString(this.noWarnings));
        this.configureTaskAttribute(document, "noValidate", Boolean.toString(this.noValidate));
        this.configureTaskAttribute(document, "classpath", this.getRuntimeClasspath());
        this.configureTaskAttribute(document, "dbname", this.dbname);
        this.configureTaskAttribute(document, "dbvendor", this.dbvendor);
        this.configureTaskAttribute(document, "dbschema", this.dbschema);
        this.configureTaskAttribute(document, "dynamic", Boolean.toString(this.dynamic));
        this.configureTaskAttribute(document, "compatible35", Boolean.toString(this.compatible35));
        this.configureTaskAttribute(document, "sqlj", Boolean.toString(this.sqlj));
        if (this.legacyMode) {
            this.getLog().warn((CharSequence)"Legacy mode - jdkComplianceLevel will NOT be taken into consideration (default will be used)");
            this.configureTaskAttribute(document, "jdkComplianceLevel", null);
        } else {
            this.configureTaskAttribute(document, "jdkComplianceLevel", "1.5".equals(this.jdkComplianceLevel) ? "5.0" : this.jdkComplianceLevel);
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.getMavenProject().getPackaging().equalsIgnoreCase("ejb")) {
            throw new MojoExecutionException("Invalid packaging type, this plugin can only be applied to ejb packaging type projects");
        }
        super.execute();
        if (!this.getOutputJarFile().exists()) {
            throw new MojoExecutionException("Deployment failed - see previous errors");
        }
        File[] workingDirectorySubdirs = this.getWorkingDirectory().listFiles((FileFilter)DirectoryFileFilter.DIRECTORY);
        if (workingDirectorySubdirs.length == 1) {
            File generatedSources = new File(workingDirectorySubdirs[0], this.getMavenProject().getBuild().getFinalName() + File.separator + "ejbModule");
            try {
                FileUtils.copyDirectory((File)generatedSources, (File)this.getGeneratedSourcesDirectory());
                FileUtils.deleteDirectory((File)new File(this.getGeneratedSourcesDirectory(), "META-INF"));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error copying generated sources", (Exception)e);
            }
            List compileSourceRoots = this.getMavenProject().getCompileSourceRoots();
            compileSourceRoots.add(this.getGeneratedSourcesDirectory().getPath());
            File generatedClasses = new File(workingDirectorySubdirs[0], this.getMavenProject().getBuild().getFinalName() + File.separator + "build" + File.separator + "classes");
            try {
                FileUtils.copyDirectory((File)generatedClasses, (File)this.getGeneratedClassesDirectory());
                Resource resource = new Resource();
                resource.setDirectory(this.getGeneratedClassesDirectory().getPath());
                this.getMavenProject().getResources().add(resource);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error copying generated classes", (Exception)e);
            }
        }
        this.getLog().warn((CharSequence)"No sources were generated");
        this.getLog().info((CharSequence)"ejbDeploy finished");
    }

    private String getRuntimeClasspath() throws MojoExecutionException {
        try {
            HashSet dependencySet = new HashSet();
            dependencySet.addAll(this.executedProject.getCompileClasspathElements());
            dependencySet.addAll(this.executedProject.getRuntimeClasspathElements());
            String compileClasspath = StringUtils.join(dependencySet, (String)File.pathSeparator);
            return compileClasspath;
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }
}

