/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.ordering;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.codehaus.mojo.versions.ordering.MavenVersionComparator;
import org.codehaus.mojo.versions.ordering.MercuryVersionComparator;
import org.codehaus.mojo.versions.ordering.NumericVersionComparator;
import org.codehaus.mojo.versions.ordering.VersionComparator;

public final class VersionComparators {
    private static final Pattern SNAPSHOT_PATTERN = Pattern.compile("(-((\\d{8}\\.\\d{6})-(\\d+))|(SNAPSHOT))$");

    private VersionComparators() {
        throw new IllegalAccessError("Utility classes should never be instantiated");
    }

    public static VersionComparator getVersionComparator(String comparisonMethod) {
        if ("numeric".equalsIgnoreCase(comparisonMethod)) {
            return new NumericVersionComparator();
        }
        if ("mercury".equalsIgnoreCase(comparisonMethod)) {
            return new MercuryVersionComparator();
        }
        return new MavenVersionComparator();
    }

    public static String alphaNumIncrement(String token) {
        int i = token.length();
        boolean done = false;
        String newToken = token;
        while (!done && i > 0) {
            char c;
            if ('0' <= (c = token.charAt(--i)) && c < '9') {
                c = (char)(c + 1);
                newToken = newToken.substring(0, i) + c + (i + 1 < newToken.length() ? newToken.substring(i + 1) : "");
                done = true;
                continue;
            }
            if (c == '9') {
                c = '0';
                newToken = newToken.substring(0, i) + c + (i + 1 < newToken.length() ? newToken.substring(i + 1) : "");
                continue;
            }
            if ('A' <= c && c < 'Z') {
                c = (char)(c + 1);
                newToken = newToken.substring(0, i) + c + (i + 1 < newToken.length() ? newToken.substring(i + 1) : "");
                done = true;
                continue;
            }
            if (c == 'Z') {
                c = 'A';
                newToken = newToken.substring(0, i) + c + (i + 1 < newToken.length() ? newToken.substring(i + 1) : "");
                continue;
            }
            if ('a' <= c && c < 'z') {
                c = (char)(c + '\u0001');
                newToken = newToken.substring(0, i) + c + (i + 1 < newToken.length() ? newToken.substring(i + 1) : "");
                done = true;
                continue;
            }
            if (c != 122) continue;
            c = 'a';
            newToken = newToken.substring(0, i) + c + (i + 1 < newToken.length() ? newToken.substring(i + 1) : "");
        }
        if (done) {
            return newToken;
        }
        boolean lastNumeric = false;
        boolean lastAlpha = false;
        boolean lastUpper = false;
        i = token.length();
        while (!lastAlpha && !lastNumeric && i > 0) {
            char c = token.charAt(--i);
            lastAlpha = Character.isLetter(c);
            lastUpper = c == Character.toUpperCase(c);
            lastNumeric = Character.isDigit(c);
        }
        if (lastAlpha) {
            if (lastUpper) {
                return token + 'A';
            }
            return token + 'a';
        }
        return token + '0';
    }

    static boolean isSnapshot(ArtifactVersion v) {
        return v != null && SNAPSHOT_PATTERN.matcher(v.toString()).find();
    }

    static ArtifactVersion stripSnapshot(ArtifactVersion v) {
        String version = v.toString();
        Matcher matcher = SNAPSHOT_PATTERN.matcher(version);
        if (matcher.find()) {
            return new DefaultArtifactVersion(version.substring(0, matcher.start(1) - 1));
        }
        return v;
    }

    static ArtifactVersion copySnapshot(ArtifactVersion source, ArtifactVersion destination) {
        Pattern matchSnapshotRegex;
        Matcher matcher;
        if (VersionComparators.isSnapshot(destination)) {
            destination = VersionComparators.stripSnapshot(destination);
        }
        if ((matcher = (matchSnapshotRegex = SNAPSHOT_PATTERN).matcher(source.toString())).find()) {
            return new DefaultArtifactVersion(destination.toString() + "-" + matcher.group(0));
        }
        return new DefaultArtifactVersion(destination.toString() + "-SNAPSHOT");
    }
}

