/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.Dependency;
import org.codehaus.mojo.versions.AbstractVersionsReportRenderer;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.UpdateScope;
import org.codehaus.mojo.versions.utils.DependencyComparator;
import org.codehaus.plexus.i18n.I18N;

public class DependencyUpdatesRenderer
extends AbstractVersionsReportRenderer {
    private final Map<Dependency, ArtifactVersions> dependencyUpdates;
    private final Map<Dependency, ArtifactVersions> dependencyManagementUpdates;

    public DependencyUpdatesRenderer(Sink sink, I18N i18n, String bundleName, Locale locale, Map<Dependency, ArtifactVersions> dependencyUpdates, Map<Dependency, ArtifactVersions> dependencyManagementUpdates) {
        super(sink, bundleName, i18n, locale);
        this.dependencyUpdates = dependencyUpdates;
        this.dependencyManagementUpdates = dependencyManagementUpdates;
    }

    protected void renderBody() {
        TreeMap<Dependency, ArtifactVersions> allUpdates = new TreeMap<Dependency, ArtifactVersions>(new DependencyComparator());
        allUpdates.putAll(this.dependencyManagementUpdates);
        allUpdates.putAll(this.dependencyUpdates);
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.getText("report.overview.title"));
        this.sink.sectionTitle1_();
        this.sink.paragraph();
        this.sink.text(this.getText("report.overview.text"));
        this.sink.paragraph_();
        this.renderSummaryTotalsTable(allUpdates);
        this.renderSummaryTable("report.overview.dependencyManagement", this.dependencyManagementUpdates, "report.overview.noDependencyManagement");
        this.renderSummaryTable("report.overview.dependency", this.dependencyUpdates, "report.overview.noDependency");
        this.sink.section1_();
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.getText("report.detail.title"));
        this.sink.sectionTitle1_();
        this.sink.paragraph();
        this.sink.text(this.getText("report.detail.text"));
        this.sink.paragraph_();
        for (Map.Entry entry : allUpdates.entrySet()) {
            this.renderDependencyDetail((Dependency)entry.getKey(), (ArtifactVersions)entry.getValue());
        }
        this.sink.section1_();
    }

    private void renderSummaryTable(String titleKey, Map<Dependency, ArtifactVersions> contents, String emptyKey) {
        this.sink.section2();
        this.sink.sectionTitle2();
        this.sink.text(this.getText(titleKey));
        this.sink.sectionTitle2_();
        if (contents.isEmpty()) {
            this.sink.paragraph();
            this.sink.text(this.getText(emptyKey));
            this.sink.paragraph_();
        } else {
            this.renderDependencySummaryTable(contents);
        }
        this.sink.section2_();
    }

    private void renderSummaryTotalsTable(Map<Dependency, ArtifactVersions> allUpdates) {
        int numInc = 0;
        int numMin = 0;
        int numMaj = 0;
        int numAny = 0;
        int numCur = 0;
        for (ArtifactVersions details : allUpdates.values()) {
            if (details.getOldestUpdate(UpdateScope.SUBINCREMENTAL) != null) {
                ++numAny;
                continue;
            }
            if (details.getOldestUpdate(UpdateScope.INCREMENTAL) != null) {
                ++numInc;
                continue;
            }
            if (details.getOldestUpdate(UpdateScope.MINOR) != null) {
                ++numMin;
                continue;
            }
            if (details.getOldestUpdate(UpdateScope.MAJOR) != null) {
                ++numMaj;
                continue;
            }
            ++numCur;
        }
        this.sink.table();
        this.sink.tableRow();
        this.sink.tableCell();
        this.renderSuccessIcon();
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(this.getText("report.overview.numUpToDate"));
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(Integer.toString(numCur));
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableCell();
        this.renderWarningIcon();
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(this.getText("report.overview.numNewerVersionAvailable"));
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(Integer.toString(numAny));
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableCell();
        this.renderWarningIcon();
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(this.getText("report.overview.numNewerIncrementalAvailable"));
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(Integer.toString(numInc));
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableCell();
        this.renderWarningIcon();
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(this.getText("report.overview.numNewerMinorAvailable"));
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(Integer.toString(numMin));
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableCell();
        this.renderWarningIcon();
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(this.getText("report.overview.numNewerMajorAvailable"));
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(Integer.toString(numMaj));
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.table_();
    }

    private void renderDependencyDetail(Dependency dependency, ArtifactVersions details) {
        this.sink.section2();
        this.sink.sectionTitle2();
        this.sink.text(ArtifactUtils.versionlessKey((String)dependency.getGroupId(), (String)dependency.getArtifactId()));
        this.sink.sectionTitle2_();
        this.renderDependencyDetailTable(dependency, details);
        this.sink.section2_();
    }
}

