/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.versions.AbstractVersionsDependencyUpdaterMojo;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;

public class ResolveRangesMojo
extends AbstractVersionsDependencyUpdaterMojo {
    public final Pattern matchRangeRegex = Pattern.compile(",");

    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        if (this.getProject().getModel().getDependencyManagement() != null && this.getProject().getModel().getDependencyManagement().getDependencies() != null && this.isProcessingDependencyManagement()) {
            this.resolveRanges(pom, this.getProject().getModel().getDependencyManagement().getDependencies());
        }
        if (this.isProcessingDependencies()) {
            this.resolveRanges(pom, this.getProject().getModel().getDependencies());
        }
    }

    private void resolveRanges(ModifiedPomXMLEventReader pom, Collection dependencies) throws XMLStreamException, MojoExecutionException {
        Iterator iter = dependencies.iterator();
        while (iter.hasNext()) {
            Artifact artifact;
            Matcher versionMatcher;
            Dependency dep = (Dependency)iter.next();
            if (this.isExcludeReactor() && this.isProducedByReactor(dep) || !(versionMatcher = this.matchRangeRegex.matcher(dep.getVersion())).find() || (artifact = this.findArtifact(dep)) == null || !this.isIncluded(artifact)) continue;
            this.getLog().debug((CharSequence)("Resolving version range for dependency: " + artifact));
            if (!PomHelper.setDependencyVersion(pom, artifact.getGroupId(), artifact.getArtifactId(), dep.getVersion(), artifact.getVersion())) continue;
            this.getLog().debug((CharSequence)("Version set to " + artifact.getVersion() + " for dependency: " + artifact));
        }
    }
}

