/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.versions.AbstractVersionsUpdaterMojo;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.UpdateScope;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.codehaus.mojo.versions.utils.DependencyComparator;
import org.codehaus.plexus.util.StringUtils;

public class DisplayDependencyUpdatesMojo
extends AbstractVersionsUpdaterMojo {
    private static final int INFO_PAD_SIZE = 72;
    protected Boolean processDependencyManagement = Boolean.TRUE;
    protected Boolean processDependencies = Boolean.TRUE;

    private static Set removeDependencyManagment(Set dependencies, Set dependencyManagement) {
        TreeSet<Dependency> result = new TreeSet<Dependency>(new DependencyComparator());
        Iterator i = dependencies.iterator();
        while (i.hasNext()) {
            Dependency c = (Dependency)i.next();
            boolean matched = false;
            Iterator j = dependencyManagement.iterator();
            while (!matched && j.hasNext()) {
                Dependency t = (Dependency)j.next();
                if (!StringUtils.equals((String)t.getGroupId(), (String)c.getGroupId()) || !StringUtils.equals((String)t.getArtifactId(), (String)c.getArtifactId()) || t.getScope() != null && !StringUtils.equals((String)t.getScope(), (String)c.getScope()) || t.getClassifier() != null && !StringUtils.equals((String)t.getClassifier(), (String)c.getClassifier()) || c.getVersion() != null && t.getVersion() != null && !StringUtils.equals((String)t.getVersion(), (String)c.getVersion())) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            result.add(c);
        }
        return result;
    }

    public boolean isProcessingDependencyManagement() {
        return !Boolean.FALSE.equals(this.processDependencyManagement);
    }

    public boolean isProcessingDependencies() {
        return !Boolean.FALSE.equals(this.processDependencies);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        TreeSet dependencyManagement = new TreeSet(new DependencyComparator());
        dependencyManagement.addAll(this.getProject().getDependencyManagement() == null ? Collections.EMPTY_LIST : this.getProject().getDependencyManagement().getDependencies());
        Set dependencies = new TreeSet(new DependencyComparator());
        dependencies.addAll(this.getProject().getDependencies());
        if (!Boolean.FALSE.equals(this.processDependencyManagement)) {
            dependencies = DisplayDependencyUpdatesMojo.removeDependencyManagment(dependencies, dependencyManagement);
        }
        try {
            if (!Boolean.FALSE.equals(this.processDependencyManagement)) {
                this.logUpdates(this.getHelper().lookupDependenciesUpdates(dependencyManagement, false), "Dependency Management");
            }
            if (!Boolean.FALSE.equals(this.processDependencies)) {
                this.logUpdates(this.getHelper().lookupDependenciesUpdates(dependencies, false), "Dependencies");
            }
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ArtifactMetadataRetrievalException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void logUpdates(Map updates, String section) {
        ArrayList withUpdates = new ArrayList();
        ArrayList<String> usingCurrent = new ArrayList<String>();
        Iterator<Object> i = updates.values().iterator();
        while (i.hasNext()) {
            ArrayList<String> t;
            ArtifactVersions versions = (ArtifactVersions)i.next();
            String left = "  " + ArtifactUtils.versionlessKey((Artifact)versions.getArtifact()) + " ";
            String current = versions.isCurrentVersionDefined() ? versions.getCurrentVersion().toString() : versions.getArtifact().getVersionRange().toString();
            ArtifactVersion latest = versions.getNewestUpdate(UpdateScope.ANY, Boolean.TRUE.equals(this.allowSnapshots));
            if (latest != null && !versions.isCurrentVersionDefined() && versions.getArtifact().getVersionRange().containsVersion(latest)) {
                latest = null;
            }
            String right = " " + (latest == null ? current : current + " -> " + latest.toString());
            ArrayList<String> arrayList = t = latest == null ? usingCurrent : withUpdates;
            if (right.length() + left.length() + 3 > 72) {
                t.add(left + "...");
                t.add(StringUtils.leftPad((String)right, (int)72));
                continue;
            }
            t.add(StringUtils.rightPad((String)left, (int)(72 - right.length()), (String)".") + right);
        }
        if (usingCurrent.isEmpty() && !withUpdates.isEmpty()) {
            this.getLog().info((CharSequence)("No dependencies in " + section + " are using the newest version."));
            this.getLog().info((CharSequence)"");
        } else if (!usingCurrent.isEmpty()) {
            this.getLog().info((CharSequence)("The following dependencies in " + section + " are using the newest version:"));
            i = usingCurrent.iterator();
            while (i.hasNext()) {
                this.getLog().info((CharSequence)((String)i.next()));
            }
            this.getLog().info((CharSequence)"");
        }
        if (withUpdates.isEmpty() && !usingCurrent.isEmpty()) {
            this.getLog().info((CharSequence)("No dependencies in " + section + " have newer versions."));
            this.getLog().info((CharSequence)"");
        } else if (!withUpdates.isEmpty()) {
            this.getLog().info((CharSequence)("The following dependencies in " + section + " have newer versions:"));
            i = withUpdates.iterator();
            while (i.hasNext()) {
                this.getLog().info((CharSequence)((String)i.next()));
            }
            this.getLog().info((CharSequence)"");
        }
    }

    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
    }
}

