/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.unix.rpm;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.codehaus.mojo.unix.MissingSettingException;
import org.codehaus.mojo.unix.PackageVersion;
import org.codehaus.mojo.unix.util.UnixUtil;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public class SpecFile {
    public String groupId;
    public String artifactId;
    public PackageVersion version;
    public String name;
    public String summary;
    public String license;
    public String distribution;
    public File icon;
    public String vendor;
    public String url;
    public String group;
    public String packager;
    public List defineStatements = new ArrayList();
    public List provides = new ArrayList();
    public List requires = new ArrayList();
    public List conflicts = new ArrayList();
    public String prefix;
    public File buildRoot;
    public String description;
    public boolean dump;
    private LinkedHashSet files = new LinkedHashSet();
    public File includePre;
    public File includePost;
    public File includePreun;
    public File includePostun;

    public void addFile(String path, String user, String group, String mode) throws IOException {
        this.files.add("%attr(" + (StringUtils.isNotEmpty((String)mode) ? mode : "-") + "," + (StringUtils.isNotEmpty((String)user) ? user : "-") + "," + (StringUtils.isNotEmpty((String)group) ? group : "-") + ") " + path);
    }

    public void addDirectory(String path, String user, String group, String mode) {
        this.files.add("%dir " + "%attr(" + (StringUtils.isNotEmpty((String)mode) ? mode : "-") + "," + (StringUtils.isNotEmpty((String)user) ? user : "-") + "," + (StringUtils.isNotEmpty((String)group) ? group : "-") + ") " + path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFile(File specFile) throws IOException, MissingSettingException {
        PrintWriter spec = null;
        try {
            spec = new PrintWriter(new FileWriter(specFile));
            this.writeTo(spec);
        }
        catch (Throwable throwable) {
            IOUtil.close(spec);
            throw throwable;
        }
        IOUtil.close((Writer)spec);
    }

    public void writeTo(PrintWriter writer) throws MissingSettingException {
        SpecWriter spec = new SpecWriter(writer);
        Iterator it = this.defineStatements.iterator();
        while (it.hasNext()) {
            spec.add("%define " + it.next());
        }
        UnixUtil.assertField((String)"version", (Object)this.version);
        spec.add("Name: " + UnixUtil.getField((String)"name", (String)this.getName()));
        spec.add("Version: " + SpecFile.getRpmVersion(this.version));
        spec.add("Release: " + SpecFile.getRpmRelease(this.version));
        spec.add("Summary: " + UnixUtil.getField((String)"summary", (String)this.summary));
        spec.add("License: " + UnixUtil.getField((String)"license", (String)this.license));
        spec.addIf("Distribution: ", this.distribution);
        spec.addIf("Icon", this.icon);
        spec.addIf("Vendor", this.vendor);
        spec.addIf("URL", this.url);
        spec.add("Group: " + UnixUtil.getField((String)"group", (String)this.group));
        spec.addIf("Packager", this.packager);
        spec.addAll("Provides", this.provides);
        spec.addAll("Requires", this.requires);
        spec.addAll("Conflicts", this.conflicts);
        spec.add("BuildRoot: " + UnixUtil.getField((String)"buildRoot", (File)this.buildRoot).getAbsolutePath());
        spec.add();
        spec.add("%description");
        spec.addIf(StringUtils.isNotEmpty((String)this.description), this.description);
        spec.add();
        spec.add("%files");
        it = this.files.iterator();
        while (it.hasNext()) {
            spec.add(it.next().toString());
        }
        spec.addIf(this.includePre != null || this.includePost != null || this.includePreun != null || this.includePostun != null, "");
        spec.addIf(this.includePre != null, "%pre");
        spec.includeIf(this.includePre);
        spec.addIf(this.includePost != null, "%post");
        spec.includeIf(this.includePost);
        spec.addIf(this.includePreun != null, "%preun");
        spec.includeIf(this.includePreun);
        spec.addIf(this.includePostun != null, "%postun");
        spec.includeIf(this.includePostun);
        spec.addIf(this.dump, "%dump");
    }

    private String getName() {
        if (this.name != null) {
            return this.name;
        }
        if (StringUtils.isEmpty((String)this.groupId) || StringUtils.isEmpty((String)this.artifactId)) {
            throw new RuntimeException("Both group id and artifact id has to be set.");
        }
        String name = this.groupId + "-" + this.artifactId;
        name = name.toLowerCase();
        return name;
    }

    private static String getRpmVersion(PackageVersion version) {
        String rpmVersionString = version.version;
        if (version.snapshot) {
            rpmVersionString = rpmVersionString + "_" + version.timestamp;
        }
        return rpmVersionString.replace('-', '_');
    }

    private static int getRpmRelease(PackageVersion version) {
        return version.revision;
    }

    private static class SpecWriter {
        private PrintWriter writer;

        public SpecWriter(PrintWriter writer) {
            this.writer = writer;
        }

        public void add(String string) {
            this.writer.println(string);
        }

        public void addIf(String field, String value) {
            if (StringUtils.isNotEmpty((String)value)) {
                this.writer.println(field + ": " + value);
            }
        }

        public void addIf(String field, File file) {
            if (file != null) {
                this.writer.println(field + ": " + file.getAbsolutePath());
            }
        }

        public void add() {
            this.writer.println();
        }

        public void addIf(boolean flag, String line) {
            if (flag) {
                this.writer.println(line);
            }
        }

        public void addAll(String prefix, List provides) {
            if (provides == null) {
                return;
            }
            Iterator iterator = provides.iterator();
            while (iterator.hasNext()) {
                this.add(prefix + ": " + iterator.next());
            }
        }

        public void includeIf(File file) {
            if (file != null) {
                this.writer.println("%include " + file.getAbsolutePath());
            }
        }
    }
}

