/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.smc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.doxia.site.renderer.SiteRenderer;
import org.codehaus.mojo.smc.DotConvertor;
import org.codehaus.mojo.smc.Util;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.CommandLineException;

public class SmcReportMojo
extends AbstractMavenReport {
    protected List pluginClasspathList;
    private File sourceDirectory;
    private File outputDirectory;
    private SiteRenderer siteRenderer;
    private MavenProject project;
    private Integer glevel;
    private boolean verbose;

    public String getName(Locale locale) {
        return "State Machine Compiler";
    }

    public String getDescription(Locale locale) {
        return "State Machine Compiler Diagrams.";
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsolutePath();
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected SiteRenderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public void generate(Sink sink, Locale locale) throws MavenReportException {
        this.executeReport(locale);
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        List files;
        if (!this.sourceDirectory.exists()) {
            this.getLog().error((CharSequence)("sourceDirectory " + this.sourceDirectory + " doesn't exist."));
            return;
        }
        if (!this.sourceDirectory.isDirectory()) {
            throw new MavenReportException("sourceDirectory " + this.sourceDirectory + " isn't a directory");
        }
        try {
            files = Util.getSmFiles(this.sourceDirectory);
        }
        catch (IOException e) {
            throw new MavenReportException("Couldn't find the .sm files in " + this.sourceDirectory, (Exception)e);
        }
        this.getLog().debug((CharSequence)("Found " + files.size() + " .sm file(s) to process."));
        for (int i = 0; i < files.size(); ++i) {
            File smFile = (File)files.get(i);
            this.getLog().debug((CharSequence)("Handling " + smFile));
            if (!this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
                this.getLog().warn((CharSequence)("the destination directory (" + this.outputDirectory + ") for file " + smFile.getAbsolutePath() + "  doesn't exist and couldn't be created. The goal with probably fail."));
            }
            ArrayList<String> arguments = new ArrayList<String>();
            if (this.verbose) {
                arguments.add("-verbose");
            }
            arguments.add("-ret");
            arguments.add("-d");
            arguments.add(this.outputDirectory.getAbsolutePath());
            arguments.add("-table");
            arguments.add("-su");
            arguments.add("html");
            arguments.add(smFile.getAbsolutePath());
            this.executeSmc(arguments);
            ArrayList<String> arguments2 = new ArrayList<String>();
            if (this.verbose) {
                arguments2.add("-verbose");
            }
            arguments2.add("-ret");
            arguments2.add("-d");
            arguments2.add(this.outputDirectory.getAbsolutePath());
            arguments2.add("-graph");
            if (this.glevel != null) {
                arguments2.add("-glevel");
                arguments2.add(this.glevel.toString());
            }
            arguments2.add("-su");
            arguments2.add("dot");
            arguments2.add(smFile.getAbsolutePath());
            this.executeSmc(arguments2);
        }
        try {
            List dotFiles = FileUtils.getFiles((File)this.outputDirectory, (String)"**/*.dot", null);
            DotConvertor.convert(dotFiles, new String[]{"png"}, this.getLog());
        }
        catch (CommandLineException e) {
            this.getLog().warn((CharSequence)"Couldn't convert the .dot files: failed finding them.", (Throwable)e);
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)"Couldn't convert the .dot files: failed finding them.", (Throwable)e);
        }
        InputStream stream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("/refresh.html");
        if (stream == null) {
            this.getLog().error((CharSequence)"Failure to generate refresh.html: template not found.");
        } else {
            try {
                Util.copyStreamToFile(stream, new File(this.outputDirectory, "refresh.html").getAbsolutePath());
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"Failure to generate refresh.html. ", (Throwable)e);
            }
        }
        this.getLog().debug((CharSequence)("Adding outputDirectory to source root: " + this.outputDirectory));
        this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
    }

    private void executeSmc(List arguments) throws MavenReportException {
        try {
            Util.executeSmc(arguments, this.getLog());
        }
        catch (Exception e) {
            throw new MavenReportException("Failure to execute Smc", e);
        }
    }

    public String getOutputName() {
        return "smc/refresh";
    }

    public boolean isExternalReport() {
        return true;
    }

    public boolean canGenerateReport() {
        try {
            return this.sourceDirectory != null && this.sourceDirectory.exists() && Util.getSmFiles(this.sourceDirectory).size() > 0;
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"error while searching for .sm files ", (Throwable)e);
            return false;
        }
    }
}

