/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rmic;

import [Ljava.lang.String;;
import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.mojo.rmic.RmiCompiler;
import org.codehaus.mojo.rmic.RmiCompilerException;
import org.codehaus.mojo.rmic.RmicConfig;
import org.codehaus.plexus.logging.AbstractLogEnabled;

public class SunRmiCompiler
extends AbstractLogEnabled
implements RmiCompiler {
    public static final String RMIC_CLASSNAME = "sun.rmi.rmic.Main";

    public void execute(RmicConfig rmiConfig, List classesToCompile) throws RmiCompilerException {
        int i;
        File toolsJar = new File(System.getProperty("java.home"), "../lib/tools.jar");
        URLClassLoader classLoader = null;
        try {
            URL[] classpathUrls = new URL[]{toolsJar.toURL()};
            classLoader = new URLClassLoader(classpathUrls, null);
        }
        catch (MalformedURLException e) {
            throw new RmiCompilerException("Unable to resolve tools.jar: " + toolsJar);
        }
        Class<?> rmicMainClass = null;
        try {
            rmicMainClass = classLoader.loadClass(RMIC_CLASSNAME);
        }
        catch (ClassNotFoundException e) {
            this.getLogger().warn("Could not find rmi compiler: sun.rmi.rmic.Main");
            this.getLogger().info("Within this classpath:");
            for (int it = 0; it < classLoader.getURLs().length; ++it) {
                URL url = classLoader.getURLs()[it];
                this.getLogger().info(" * " + url.toExternalForm());
            }
            throw new RmiCompilerException("Could not find sun.rmi.rmic.Main on the classpath.");
        }
        ArrayList<String> arguments = new ArrayList<String>();
        List classpathList = rmiConfig.getRmicClasspathElements();
        if (classpathList.size() > 0) {
            StringBuffer classpath = new StringBuffer();
            for (i = 0; i < classpathList.size(); ++i) {
                classpath.append(classpathList.get(i) + File.pathSeparator);
            }
            arguments.add("-classpath");
            arguments.add(classpath.toString());
        }
        arguments.add("-d");
        arguments.add(rmiConfig.getOutputDirectory().getAbsolutePath());
        if (rmiConfig.getVersion() != null) {
            arguments.add("-v" + rmiConfig.getVersion());
        }
        if (rmiConfig.isIiop()) {
            arguments.add("-iiop");
            if (rmiConfig.isNoLocalStubs()) {
                arguments.add("-nolocalstubs");
            }
        }
        if (rmiConfig.isIdl()) {
            arguments.add("-idl");
            if (rmiConfig.isNoValueMethods()) {
                arguments.add("-noValueMethods");
            }
        }
        if (rmiConfig.isKeep()) {
            arguments.add("-keep");
        }
        if (this.getLogger().isDebugEnabled() || rmiConfig.isVerbose()) {
            arguments.add("-verbose");
        } else if (rmiConfig.isNowarn()) {
            arguments.add("-nowarn");
        }
        Iterator it = classesToCompile.iterator();
        while (it.hasNext()) {
            String remoteClass = (String)it.next();
            arguments.add(remoteClass);
        }
        String[] args = arguments.toArray(new String[arguments.size()]);
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().debug("rmic arguments: ");
            for (i = 0; i < args.length; ++i) {
                String arg = args[i];
                this.getLogger().debug(arg);
            }
        }
        this.executeMain(rmicMainClass, args);
    }

    private void executeMain(Class rmicMainClass, String[] args) throws RmiCompilerException {
        Method compile;
        Object main;
        try {
            Constructor constructor = rmicMainClass.getConstructor(OutputStream.class, String.class);
            main = constructor.newInstance(System.out, "rmic");
            compile = rmicMainClass.getMethod("compile", String;.class);
        }
        catch (NoSuchMethodException e) {
            throw new RmiCompilerException("Error while initializing rmic.", e);
        }
        catch (IllegalAccessException e) {
            throw new RmiCompilerException("Error while initializing rmic.", e);
        }
        catch (InvocationTargetException e) {
            throw new RmiCompilerException("Error while initializing rmic.", e);
        }
        catch (InstantiationException e) {
            throw new RmiCompilerException("Error while initializing rmic.", e);
        }
        try {
            compile.invoke(main, new Object[]{args});
        }
        catch (IllegalAccessException e) {
            throw new RmiCompilerException("Error while executing rmic.", e);
        }
        catch (InvocationTargetException e) {
            throw new RmiCompilerException("Error while executing rmic.", e);
        }
    }
}

