/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.mrm.api;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.codehaus.mojo.mrm.api.DefaultDirectoryEntry;
import org.codehaus.mojo.mrm.api.DirectoryEntry;
import org.codehaus.mojo.mrm.api.Entry;
import org.codehaus.mojo.mrm.api.FileEntry;
import org.codehaus.mojo.mrm.api.FileSystem;

public abstract class BaseFileSystem
implements FileSystem {
    private static final long serialVersionUID = 1L;
    private final DirectoryEntry root = new DefaultDirectoryEntry(this, null, "");

    public DirectoryEntry getRoot() {
        return this.root;
    }

    public Entry get(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.length() == 0) {
            return this.root;
        }
        String[] parts = path.split("/");
        if (parts.length == 0) {
            return this.root;
        }
        DirectoryEntry parent = this.root;
        for (int i = 0; i < parts.length - 1; ++i) {
            parent = new DefaultDirectoryEntry(this, parent, parts[i]);
        }
        return this.get(parent, parts[parts.length - 1]);
    }

    protected Entry get(DirectoryEntry parent, String name) {
        parent.getClass();
        Entry[] entries = this.listEntries(parent);
        if (entries != null) {
            for (int i = 0; i < entries.length; ++i) {
                if (!name.equals(entries[i].getName())) continue;
                return entries[i];
            }
        }
        return null;
    }

    public DirectoryEntry mkdir(DirectoryEntry parent, String name) {
        throw new UnsupportedOperationException();
    }

    public FileEntry put(DirectoryEntry parent, String name, InputStream content) throws IOException {
        throw new UnsupportedOperationException();
    }

    public FileEntry put(DirectoryEntry parent, String name, byte[] content) throws IOException {
        return this.put(parent, name, new ByteArrayInputStream(content));
    }

    public void remove(Entry entry) {
        throw new UnsupportedOperationException();
    }
}

