/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class SortedProperties
extends Properties {
    private static final long serialVersionUID = -1147150444452577558L;
    protected String encoding;
    protected boolean removeHeader;

    public SortedProperties(String encoding) {
        this(encoding, true);
    }

    public SortedProperties(String encoding, boolean removeHeader) {
        this.encoding = encoding;
        this.removeHeader = removeHeader;
    }

    public SortedProperties(Properties defaults) {
        super(defaults);
    }

    @Override
    public Enumeration<Object> keys() {
        Vector<Object> result;
        ArrayList<Object> objects = Collections.list(super.keys());
        try {
            List<String> list = SortedProperties.toGenericList(objects, String.class);
            Collections.sort(list);
            result = new Vector<String>(list);
        }
        catch (IllegalArgumentException e) {
            result = new Vector<Object>(objects);
        }
        return result.elements();
    }

    public SortedProperties load(File src) throws IOException {
        try (InputStream reader = Files.newInputStream(src.toPath(), new OpenOption[0]);){
            this.load(reader);
        }
        return this;
    }

    public void store(File dst) throws IOException {
        try (OutputStream writer = Files.newOutputStream(dst.toPath(), new OpenOption[0]);){
            this.store(writer, null);
        }
    }

    public static <O> List<O> toGenericList(List<?> list, Class<O> type) throws IllegalArgumentException {
        if (list.isEmpty()) {
            return list;
        }
        for (Object o : list) {
            if (type.isAssignableFrom(o.getClass())) continue;
            throw new IllegalArgumentException("can not cast List with object of type " + o.getClass() + " to " + type + " type!");
        }
        return list;
    }
}

