/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import javax.inject.Inject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.mojo.license.AbstractAddThirdPartyMojo;
import org.codehaus.mojo.license.AddThirdPartyMojo;
import org.codehaus.mojo.license.api.DependenciesTool;
import org.codehaus.mojo.license.api.ThirdPartyTool;
import org.codehaus.mojo.license.model.LicenseMap;
import org.codehaus.mojo.license.utils.ModuleHelper;
import org.codehaus.mojo.license.utils.SortedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="aggregate-add-third-party", aggregator=true, defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class AggregatorAddThirdPartyMojo
extends AbstractAddThirdPartyMojo {
    private static final Logger LOG = LoggerFactory.getLogger(AggregatorAddThirdPartyMojo.class);
    @Parameter(property="reactorProjects", readonly=true, required=true)
    private List<MavenProject> reactorProjects;
    @Parameter(property="license.includedModules")
    private String[] includedModules;
    @Parameter(property="license.excludedModules")
    private String[] excludedModules;
    @Parameter(property="license.skipAggregateAddThirdParty", defaultValue="false")
    private boolean skipAggregateAddThirdParty;
    @Deprecated
    @Parameter(property="license.aggregateMissingLicensesFileArtifact")
    private String aggregateMissingLicensesFileArtifact;
    @Deprecated
    @Parameter(property="license.aggregateMissingLicensesFile")
    private File aggregateMissingLicensesFile;

    @Inject
    public AggregatorAddThirdPartyMojo(ThirdPartyTool thirdPartyTool, DependenciesTool dependenciesTool, MavenProjectHelper projectHelper) {
        super(thirdPartyTool, dependenciesTool, projectHelper);
    }

    @Override
    public boolean isSkip() {
        return this.skipAggregateAddThirdParty;
    }

    @Override
    protected boolean checkPackaging() {
        return this.acceptPackaging("pom");
    }

    @Override
    protected boolean shouldSkip() {
        return !this.doGenerate && !this.doGenerateBundle;
    }

    @Override
    protected void init() throws Exception {
        if (this.aggregateMissingLicensesFile != null && !this.aggregateMissingLicensesFile.equals(this.missingFile)) {
            LOG.warn("");
            LOG.warn("You should use *missingFile* parameter instead of deprecated *aggregateMissingLicensesFile*.");
            LOG.warn("");
            this.missingFile = this.aggregateMissingLicensesFile;
        }
        if (this.aggregateMissingLicensesFileArtifact != null && !this.aggregateMissingLicensesFileArtifact.equals(this.missingLicensesFileArtifact)) {
            LOG.warn("");
            LOG.warn("You should use *missingLicensesFileArtifact* parameter instead of deprecated *aggregateMissingLicensesFileArtifact*.");
            LOG.warn("");
            this.missingLicensesFileArtifact = this.aggregateMissingLicensesFileArtifact;
        }
        super.init();
    }

    @Override
    protected void doAction() throws Exception {
        List<MavenProject> modules = ModuleHelper.getFilteredModules(this.reactorProjects, this.includedModules, this.excludedModules);
        if (this.isVerbose()) {
            LOG.info("After executing on {} project(s)", (Object)modules.size());
        }
        this.licenseMap = new LicenseMap();
        Artifact pluginArtifact = (Artifact)this.project.getPluginArtifactMap().get("org.codehaus.mojo:license-maven-plugin");
        String groupId = null;
        String artifactId = null;
        String version = null;
        if (pluginArtifact == null) {
            Plugin plugin = (Plugin)this.project.getPluginManagement().getPluginsAsMap().get("org.codehaus.mojo:license-maven-plugin");
            if (plugin != null) {
                groupId = plugin.getGroupId();
                artifactId = plugin.getArtifactId();
                version = plugin.getVersion();
            }
        } else {
            groupId = pluginArtifact.getGroupId();
            artifactId = pluginArtifact.getArtifactId();
            version = pluginArtifact.getVersion();
        }
        if (groupId == null) {
            try {
                PluginDescriptor pd = (PluginDescriptor)this.getPluginContext().get("pluginDescriptor");
                groupId = pd.getGroupId();
                artifactId = pd.getArtifactId();
                version = pd.getVersion();
            }
            catch (ClassCastException e) {
                LOG.warn("Failed to access PluginDescriptor", (Throwable)e);
            }
            if (groupId == null) {
                throw new IllegalStateException("Failed to determine the license-maven-plugin artifact.Please add it to your parent POM.");
            }
        }
        String addThirdPartyRoleHint = groupId + ":" + artifactId + ":" + version + ":add-third-party";
        LOG.info("The default plugin hint is: " + addThirdPartyRoleHint);
        for (MavenProject mavenProject : modules) {
            if (this.getProject().equals((Object)mavenProject) && !this.acceptPomPackaging) continue;
            AddThirdPartyMojo mojo = new AddThirdPartyMojo(this.thirdPartyTool, this.dependenciesTool, this.projectHelper);
            mojo.initFromMojo(this, mavenProject);
            LicenseMap childLicenseMap = mojo.licenseMap;
            if (this.isVerbose()) {
                LOG.info("Found {} license(s) in module {}:{}", new Object[]{childLicenseMap.size(), mojo.project.getGroupId(), mojo.project.getArtifactId()});
            }
            this.licenseMap.putAll(childLicenseMap);
        }
        LOG.info("Detected {} license(s).", (Object)this.licenseMap.size());
        if (this.isVerbose()) {
            for (Map.Entry entry : this.licenseMap.entrySet()) {
                LOG.info(" - {} for {} artifact(s).", entry.getKey(), (Object)((SortedSet)entry.getValue()).size());
            }
        }
        this.consolidate();
        this.checkUnsafeDependencies();
        boolean safeLicense = this.checkForbiddenLicenses();
        this.checkBlacklist(safeLicense);
        this.writeThirdPartyFile();
        this.checkMissing(CollectionUtils.isNotEmpty((Collection)this.unsafeDependencies));
    }

    @Override
    protected SortedMap<String, MavenProject> loadDependencies() {
        return this.getHelper().getArtifactCache();
    }

    @Override
    protected SortedProperties createUnsafeMapping() throws ProjectBuildingException, IOException, MojoExecutionException {
        String path = this.missingFile.getAbsolutePath().substring(this.getProject().getBasedir().getAbsolutePath().length() + 1);
        if (this.isVerbose()) {
            LOG.info("Use missing file path: {}", (Object)path);
        }
        SortedProperties unsafeMappings = new SortedProperties(this.getEncoding());
        for (MavenProject o : this.reactorProjects) {
            SortedSet<MavenProject> unsafe;
            MavenProject p = o;
            File file = new File(p.getBasedir(), path);
            if (file.exists()) {
                SortedProperties tmp = this.getHelper().loadUnsafeMapping(this.licenseMap, file, null, this.projectDependencies);
                unsafeMappings.putAll((Map<?, ?>)tmp);
            }
            if (!CollectionUtils.isEmpty(unsafe = this.getHelper().getProjectsWithNoLicense(this.licenseMap))) continue;
            break;
        }
        return unsafeMappings;
    }
}

