/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.extended.spreadsheet;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Scm;
import org.codehaus.mojo.license.download.ProjectLicenseInfo;
import org.codehaus.mojo.license.extended.ExtendedInfo;
import org.codehaus.mojo.license.extended.InfoFile;
import org.codehaus.mojo.license.extended.spreadsheet.SpreadsheetUtil;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.OdfSpreadsheetDocument;
import org.odftoolkit.odfdom.doc.table.OdfTable;
import org.odftoolkit.odfdom.doc.table.OdfTableCell;
import org.odftoolkit.odfdom.doc.table.OdfTableCellRange;
import org.odftoolkit.odfdom.doc.table.OdfTableColumn;
import org.odftoolkit.odfdom.doc.table.OdfTableRow;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.OdfSettingsDom;
import org.odftoolkit.odfdom.dom.element.config.ConfigConfigItemElement;
import org.odftoolkit.odfdom.dom.element.config.ConfigConfigItemMapEntryElement;
import org.odftoolkit.odfdom.dom.element.style.StyleParagraphPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableCellPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTextPropertiesElement;
import org.odftoolkit.odfdom.dom.element.text.TextAElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.style.props.OdfTableColumnProperties;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeStyles;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.type.Color;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CalcFileWriter {
    private static final Logger LOG = LoggerFactory.getLogger(CalcFileWriter.class);
    private static final String HEADER_CELL_STYLE = "headerCellStyle";
    private static final String HYPERLINK_NORMAL_STYLE = "hyperlinkNormalStyle";
    private static final String HYPERLINK_GRAY_STYLE = "hyperlinkGrayStyle";
    private static final String GRAY_CELL_STYLE = "grayCellStyle";
    private static final String NORMAL_CELL_STYLE = "normalCellStyle";
    private static final int DOWNLOAD_COLUMN_WIDTH = 6000;
    private static final String VALUE_TYPE_STRING = "string";
    private static final String CONFIG_TYPE_SHORT = "short";

    private CalcFileWriter() {
    }

    public static void write(List<ProjectLicenseInfo> projectLicenseInfos, File licensesCalcOutputFile) {
        if (CollectionUtils.isEmpty(projectLicenseInfos)) {
            LOG.debug("Nothing to write to excel, no project data.");
            return;
        }
        LOG.debug("Write LibreOffice Calc file {}", (Object)licensesCalcOutputFile);
        try (OdfSpreadsheetDocument spreadsheet = OdfSpreadsheetDocument.newSpreadsheetDocument();){
            List tableList = spreadsheet.getTableList();
            OdfTable table = !tableList.isEmpty() ? (OdfTable)tableList.get(0) : OdfTable.newTable((OdfDocument)spreadsheet);
            table.setTableName("License information");
            CalcFileWriter.createHeaderStyle(spreadsheet);
            CalcFileWriter.createHeader(projectLicenseInfos, spreadsheet, table);
            CalcFileWriter.writeData(projectLicenseInfos, spreadsheet, table, CalcFileWriter.convertToOdfColor(SpreadsheetUtil.ALTERNATING_ROWS_COLOR));
            try (OutputStream fileOut = Files.newOutputStream(licensesCalcOutputFile.toPath(), new OpenOption[0]);){
                spreadsheet.save(fileOut);
                LOG.debug("Written LibreOffice Calc file {}", (Object)licensesCalcOutputFile);
            }
            catch (IOException e) {
                LOG.error("Error on storing LibreOffice Calc file with license and other information", (Throwable)e);
            }
        }
        catch (Exception e) {
            LOG.error("Error on creating LibreOffice Calc file with license and other information", (Throwable)e);
        }
    }

    private static Color convertToOdfColor(int[] color) {
        return new Color(color[0], color[1], color[2]);
    }

    private static void createHeader(List<ProjectLicenseInfo> projectLicenseInfos, OdfSpreadsheetDocument spreadsheet, OdfTable table) {
        boolean hasExtendedInfo = false;
        for (ProjectLicenseInfo projectLicenseInfo : projectLicenseInfos) {
            if (projectLicenseInfo.getExtendedInfo() == null) continue;
            hasExtendedInfo = true;
            break;
        }
        OdfTableRow mavenJarRow = table.getRowByIndex(0);
        OdfTableRow secondHeaderRow = table.appendRow();
        OdfTableRow thirdHeaderRow = table.appendRow();
        CalcFileWriter.createMergedCellsInRow(table, 0, 24, mavenJarRow, "Maven information", 0, HEADER_CELL_STYLE);
        if (hasExtendedInfo) {
            CalcFileWriter.createMergedCellsInRow(table, 25, 40, mavenJarRow, "JAR Content", 0, HEADER_CELL_STYLE);
        }
        CalcFileWriter.createMergedCellsInRow(table, 0, 1, secondHeaderRow, "General", 1, HEADER_CELL_STYLE);
        CalcFileWriter.createMergedCellsInRow(table, 2, 5, secondHeaderRow, "Plugin ID", 1, HEADER_CELL_STYLE);
        CalcFileWriter.setColumnWidth(table, 1, 768);
        CalcFileWriter.createMergedCellsInRow(table, 6, 11, secondHeaderRow, "Licenses", 1, HEADER_CELL_STYLE);
        CalcFileWriter.setColumnWidth(table, 5, 768);
        CalcFileWriter.createMergedCellsInRow(table, 12, 19, secondHeaderRow, "Developers", 1, HEADER_CELL_STYLE);
        CalcFileWriter.setColumnWidth(table, 11, 768);
        CalcFileWriter.createMergedCellsInRow(table, 20, 24, secondHeaderRow, "Miscellaneous", 1, HEADER_CELL_STYLE);
        CalcFileWriter.setColumnWidth(table, 19, 768);
        if (hasExtendedInfo) {
            CalcFileWriter.createMergedCellsInRow(table, 25, 28, secondHeaderRow, "MANIFEST.MF", 1, HEADER_CELL_STYLE);
            CalcFileWriter.setColumnWidth(table, 19, 768);
            CalcFileWriter.createMergedCellsInRow(table, 29, 32, secondHeaderRow, "Notices text files", 1, HEADER_CELL_STYLE);
            CalcFileWriter.setColumnWidth(table, 28, 768);
            CalcFileWriter.createMergedCellsInRow(table, 33, 36, secondHeaderRow, "License text files", 1, HEADER_CELL_STYLE);
            CalcFileWriter.setColumnWidth(table, 32, 768);
            CalcFileWriter.createMergedCellsInRow(table, 37, 40, secondHeaderRow, "SPDX license id matched", 1, HEADER_CELL_STYLE);
            CalcFileWriter.setColumnWidth(table, 36, 768);
        }
        CalcFileWriter.setColumnWidth(table, SpreadsheetUtil.getDownloadColumn(hasExtendedInfo) - 1, 768);
        CalcFileWriter.setColumnWidth(table, SpreadsheetUtil.getDownloadColumn(hasExtendedInfo), 6000);
        CalcFileWriter.createCellsInRow(thirdHeaderRow, 0, HEADER_CELL_STYLE, "Name");
        CalcFileWriter.createCellsInRow(thirdHeaderRow, 2, HEADER_CELL_STYLE, "Group ID", "Artifact ID", "Version");
        CalcFileWriter.createCellsInRow(thirdHeaderRow, 6, HEADER_CELL_STYLE, "Name", "URL", "Distribution", "Comments", "File");
        CalcFileWriter.createCellsInRow(thirdHeaderRow, 12, HEADER_CELL_STYLE, "Id", "Email", "Name", "Organization", "Organization URL", "URL", "Timezone");
        CalcFileWriter.createCellsInRow(thirdHeaderRow, 20, HEADER_CELL_STYLE, "Inception Year", "Organization", "SCM", "URL");
        int headerLineCount = 3;
        if (hasExtendedInfo) {
            CalcFileWriter.createCellsInRow(thirdHeaderRow, 25, HEADER_CELL_STYLE, "Bundle license", "Bundle vendor", "Implementation vendor");
            CalcFileWriter.createInfoFileCellsInRow(thirdHeaderRow, HEADER_CELL_STYLE, 29, 33, 37);
            CalcFileWriter.createFreezePane(spreadsheet, table, SpreadsheetUtil.getDownloadColumn(true) - 1, headerLineCount);
        } else {
            CalcFileWriter.createFreezePane(spreadsheet, table, SpreadsheetUtil.getDownloadColumn(false) - 1, headerLineCount);
        }
        CalcFileWriter.createFreezePane(spreadsheet, table, 1, headerLineCount);
    }

    private static void setColumnWidth(OdfTable table, int column, int width) {
        table.getColumnByIndex(column).getOdfElement().setProperty(OdfTableColumnProperties.ColumnWidth, width / 100 + "mm");
    }

    private static void createFreezePane(OdfSpreadsheetDocument spreadsheet, OdfTable table, int column, int lineCount) {
        OdfSettingsDom settingsDom;
        try {
            settingsDom = spreadsheet.getSettingsDom();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        NodeList childNodes = settingsDom.getFirstChild().getFirstChild().getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node subChild;
            Node child = childNodes.item(i);
            if (!"config:config-item-set".equals(child.getNodeName()) || !"ooo:view-settings".equals(((Element)child).getAttribute("config:name"))) continue;
            NodeList subChilds = child.getChildNodes();
            for (int j = 0; !(j >= subChilds.getLength() || "config:config-item-map-indexed".equals((subChild = subChilds.item(j)).getNodeName()) && "Views".equals(((Element)subChild).getAttribute("config:name"))); ++j) {
            }
            break;
        }
        XPath xpath = settingsDom.getXPath();
        try {
            NodeList list = (NodeList)xpath.evaluate("/office:document-settings/office:settings/config:config-item-set/config:config-item-map-indexed/config:config-item-map-entry/config:config-item-map-named/config:config-item-map-entry", settingsDom, XPathConstants.NODE);
            if (list instanceof ConfigConfigItemMapEntryElement) {
                ConfigConfigItemMapEntryElement entryElement = (ConfigConfigItemMapEntryElement)list;
                CalcFileWriter.appendConfigItemElement(entryElement, "HorizontalSplitMode", CONFIG_TYPE_SHORT, "2");
                CalcFileWriter.appendConfigItemElement(entryElement, "VerticalSplitMode", CONFIG_TYPE_SHORT, "2");
                CalcFileWriter.appendConfigItemElement(entryElement, "HorizontalSplitPosition", "int", "1");
                CalcFileWriter.appendConfigItemElement(entryElement, "VerticalSplitPosition", "int", "3");
                CalcFileWriter.appendConfigItemElement(entryElement, "ActiveSplitRange", CONFIG_TYPE_SHORT, "3");
                CalcFileWriter.appendConfigItemElement(entryElement, "PositionLeft", "int", "0");
                CalcFileWriter.appendConfigItemElement(entryElement, "PositionRight", "int", "1");
                CalcFileWriter.appendConfigItemElement(entryElement, "PositionTop", "int", "0");
                CalcFileWriter.appendConfigItemElement(entryElement, "PositionBottom", "int", "3");
                CalcFileWriter.appendConfigItemElement(entryElement, "ShowGrid", "boolean", "true");
                CalcFileWriter.appendConfigItemElement(entryElement, "AnchoredTextOverflowLegacy", "boolean", "false");
            }
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    private static void appendConfigItemElement(ConfigConfigItemMapEntryElement entryElement, String configName, String configType, String nodeValue) {
        ConfigConfigItemElement horizontalSplitMode = null;
        if (entryElement.hasChildNodes()) {
            NodeList nodeList = entryElement.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                ConfigConfigItemElement itemElement;
                Node node = nodeList.item(i);
                if (!(node instanceof ConfigConfigItemElement) || !configName.equals((itemElement = (ConfigConfigItemElement)node).getConfigNameAttribute())) continue;
                horizontalSplitMode = (ConfigConfigItemElement)node;
                break;
            }
        }
        if (horizontalSplitMode == null) {
            horizontalSplitMode = entryElement.newConfigConfigItemElement(configName, configType);
        } else if (horizontalSplitMode.hasChildNodes()) {
            for (int i = 0; i < horizontalSplitMode.getLength(); ++i) {
                Node child = horizontalSplitMode.item(i);
                if (child.getNodeType() != 3) continue;
                child.setNodeValue(nodeValue);
                return;
            }
        }
        horizontalSplitMode.newTextNode(nodeValue);
    }

    private static void createHeaderStyle(OdfSpreadsheetDocument spreadsheet) {
        OdfOfficeStyles styles = spreadsheet.getOrCreateDocumentStyles();
        OdfStyle headerStyle = styles.newStyle(HEADER_CELL_STYLE, OdfStyleFamily.TableCell);
        headerStyle.setProperty(StyleTextPropertiesElement.FontFamily, "Arial");
        headerStyle.setProperty(StyleTextPropertiesElement.FontWeight, "bold");
        headerStyle.setProperty(StyleTableCellPropertiesElement.BackgroundColor, "#CCFFCC");
        headerStyle.setProperty(StyleParagraphPropertiesElement.TextAlign, "center");
        headerStyle.setProperty(StyleTableCellPropertiesElement.VerticalAlign, "middle");
        headerStyle.setProperty(StyleTableCellPropertiesElement.Border, "1.0pt solid #000000");
    }

    private static void writeData(List<ProjectLicenseInfo> projectLicenseInfos, OdfSpreadsheetDocument wb, OdfTable table, Color alternatingRowsColor) {
        int firstRowIndex = 3;
        int currentRowIndex = 3;
        HashMap<Integer, OdfTableRow> rowMap = new HashMap<Integer, OdfTableRow>();
        boolean hasExtendedInfo = false;
        OdfStyle hyperlinkStyleNormal = CalcFileWriter.createHyperlinkStyle(wb, HYPERLINK_NORMAL_STYLE, null);
        OdfStyle hyperlinkStyleGray = CalcFileWriter.createHyperlinkStyle(wb, HYPERLINK_GRAY_STYLE, alternatingRowsColor);
        boolean grayBackground = false;
        OdfOfficeStyles officeStyles = wb.getOrCreateDocumentStyles();
        OdfStyle styleGray = officeStyles.newStyle(GRAY_CELL_STYLE, OdfStyleFamily.TableCell);
        styleGray.setProperty(StyleTableCellPropertiesElement.BackgroundColor, alternatingRowsColor.toString());
        styleGray.setProperty(OdfTableColumnProperties.UseOptimalColumnWidth, String.valueOf(true));
        OdfStyle styleNormal = officeStyles.newStyle(NORMAL_CELL_STYLE, OdfStyleFamily.TableCell);
        styleNormal.setProperty(OdfTableColumnProperties.UseOptimalColumnWidth, String.valueOf(true));
        for (ProjectLicenseInfo projectInfo : projectLicenseInfos) {
            OdfStyle hyperlinkStyle;
            OdfStyle cellStyle;
            LOG.debug("Writing {}:{} into LibreOffice calc file", (Object)projectInfo.getGroupId(), (Object)projectInfo.getArtifactId());
            if (grayBackground) {
                cellStyle = styleGray;
                hyperlinkStyle = hyperlinkStyleGray;
            } else {
                cellStyle = styleNormal;
                hyperlinkStyle = hyperlinkStyleNormal;
            }
            grayBackground = !grayBackground;
            int extraRows = 0;
            OdfTableRow currentRow = table.appendRow();
            rowMap.put(currentRowIndex, currentRow);
            CalcFileWriter.createDataCellsInRow(currentRow, 2, cellStyle, projectInfo.getGroupId(), projectInfo.getArtifactId(), projectInfo.getVersion());
            CellListParameter cellListParameter = new CellListParameter(table, rowMap, cellStyle);
            SpreadsheetUtil.CurrentRowData currentRowData = new SpreadsheetUtil.CurrentRowData(currentRowIndex, extraRows, hasExtendedInfo);
            extraRows = CalcFileWriter.addList(cellListParameter, currentRowData, 6, 5, projectInfo.getLicenses(), (licenseRow, license) -> {
                OdfTableCell[] licenses = CalcFileWriter.createDataCellsInRow(licenseRow, 6, cellStyle, license.getName(), license.getUrl(), license.getDistribution(), license.getComments(), license.getFile());
                CalcFileWriter.addHyperlinkIfExists(table, licenses[1], hyperlinkStyle);
            });
            ExtendedInfo extendedInfo = projectInfo.getExtendedInfo();
            if (extendedInfo != null) {
                hasExtendedInfo = true;
                CalcFileWriter.createDataCellsInRow(currentRow, 0, cellStyle, extendedInfo.getName());
                currentRowData = new SpreadsheetUtil.CurrentRowData(currentRowIndex, extraRows, hasExtendedInfo);
                extraRows = CalcFileWriter.addList(cellListParameter, currentRowData, 12, 7, extendedInfo.getDevelopers(), (developerRow, developer) -> {
                    OdfTableCell[] licenses = CalcFileWriter.createDataCellsInRow(developerRow, 12, cellStyle, developer.getId(), developer.getEmail(), developer.getName(), developer.getOrganization(), developer.getOrganizationUrl(), developer.getUrl(), developer.getTimezone());
                    CalcFileWriter.addHyperlinkIfExists(table, licenses[1], hyperlinkStyle, true);
                    CalcFileWriter.addHyperlinkIfExists(table, licenses[4], hyperlinkStyle);
                    CalcFileWriter.addHyperlinkIfExists(table, licenses[5], hyperlinkStyle);
                });
                OdfTableCell[] miscCells = CalcFileWriter.createDataCellsInRow(currentRow, 20, cellStyle, extendedInfo.getInceptionYear(), Optional.ofNullable(extendedInfo.getOrganization()).map(Organization::getName).orElse(null), Optional.ofNullable(extendedInfo.getScm()).map(Scm::getUrl).orElse(null), extendedInfo.getUrl());
                CalcFileWriter.addHyperlinkIfExists(table, miscCells[2], hyperlinkStyle);
                CalcFileWriter.addHyperlinkIfExists(table, miscCells[3], hyperlinkStyle);
                CalcFileWriter.createDataCellsInRow(currentRow, 25, cellStyle, extendedInfo.getBundleLicense(), extendedInfo.getBundleVendor(), extendedInfo.getImplementationVendor());
                if (!CollectionUtils.isEmpty(extendedInfo.getInfoFiles())) {
                    ArrayList<InfoFile> notices = new ArrayList<InfoFile>();
                    ArrayList<InfoFile> licenses = new ArrayList<InfoFile>();
                    ArrayList<InfoFile> spdxs = new ArrayList<InfoFile>();
                    extendedInfo.getInfoFiles().forEach(infoFile -> {
                        switch (infoFile.getType()) {
                            case LICENSE: {
                                licenses.add((InfoFile)infoFile);
                                break;
                            }
                            case NOTICE: {
                                notices.add((InfoFile)infoFile);
                                break;
                            }
                            case SPDX_LICENSE: {
                                spdxs.add((InfoFile)infoFile);
                                break;
                            }
                        }
                    });
                    currentRowData = new SpreadsheetUtil.CurrentRowData(currentRowIndex, extraRows, hasExtendedInfo);
                    extraRows = CalcFileWriter.addInfoFileList(cellListParameter, currentRowData, 29, 3, notices);
                    currentRowData = new SpreadsheetUtil.CurrentRowData(currentRowIndex, extraRows, hasExtendedInfo);
                    extraRows = CalcFileWriter.addInfoFileList(cellListParameter, currentRowData, 33, 3, licenses);
                    currentRowData = new SpreadsheetUtil.CurrentRowData(currentRowIndex, extraRows, hasExtendedInfo);
                    extraRows = CalcFileWriter.addInfoFileList(cellListParameter, currentRowData, 37, 3, spdxs);
                } else if (cellListParameter.cellStyle != null) {
                    CalcFileWriter.setStyleOnEmptyCells(cellListParameter, currentRowData, 29, 3);
                    CalcFileWriter.setStyleOnEmptyCells(cellListParameter, currentRowData, 33, 3);
                    CalcFileWriter.setStyleOnEmptyCells(cellListParameter, currentRowData, 37, 3);
                }
            } else {
                CalcFileWriter.createDataCellsInRow(currentRow, 0, cellStyle, 1);
                CalcFileWriter.createDataCellsInRow(currentRow, 12, cellStyle, 7);
                CalcFileWriter.createDataCellsInRow(currentRow, 20, cellStyle, 4);
            }
            int downloadColumn = SpreadsheetUtil.getDownloadColumn(hasExtendedInfo);
            if (CollectionUtils.isNotEmpty(projectInfo.getDownloaderMessages())) {
                currentRowData = new SpreadsheetUtil.CurrentRowData(currentRowIndex, extraRows, hasExtendedInfo);
                extraRows = CalcFileWriter.addList(cellListParameter, currentRowData, downloadColumn, 1, projectInfo.getDownloaderMessages(), (licenseRow, message) -> {
                    OdfTableCell[] licenses = CalcFileWriter.createDataCellsInRow(licenseRow, downloadColumn, cellStyle, message);
                    if (message.matches("\\bhttps?://\\S+")) {
                        CalcFileWriter.addHyperlinkIfExists(table, licenses[0], hyperlinkStyle);
                    }
                });
            } else {
                OdfTableCell cell = currentRow.getCellByIndex(downloadColumn);
                cell.setValueType(VALUE_TYPE_STRING);
                cell.getOdfElement().setStyleName(CalcFileWriter.getCellStyleName(cellStyle));
            }
            currentRowIndex += extraRows + 1;
        }
        CalcFileWriter.autosizeColumns(table, hasExtendedInfo, currentRowIndex);
    }

    private static OdfStyle createHyperlinkStyle(OdfSpreadsheetDocument wb, String name, Color backgroundColor) {
        OdfOfficeStyles styles = wb.getOrCreateDocumentStyles();
        OdfStyle hyperlinkStyle = styles.newStyle(name, OdfStyleFamily.TableCell);
        hyperlinkStyle.setProperty(StyleTextPropertiesElement.FontFamily, "Arial");
        hyperlinkStyle.setProperty(StyleTextPropertiesElement.Color, Color.BLUE.toString());
        hyperlinkStyle.setProperty(StyleParagraphPropertiesElement.TextAlign, "center");
        hyperlinkStyle.setProperty(StyleTableCellPropertiesElement.VerticalAlign, "middle");
        if (backgroundColor != null) {
            hyperlinkStyle.setProperty(StyleTableCellPropertiesElement.BackgroundColor, backgroundColor.toString());
        }
        return hyperlinkStyle;
    }

    private static void autosizeColumns(OdfTable table, boolean hasExtendedInfo, int rows) {
        CalcFileWriter.autosizeColumns(table, rows, new Pair[]{new ImmutablePair((Object)0, (Object)1), new ImmutablePair((Object)2, (Object)5), new ImmutablePair((Object)6, (Object)11), new ImmutablePair((Object)12, (Object)18), new ImmutablePair((Object)21, (Object)24)});
        CalcFileWriter.setColumnWidth(table, 18, SpreadsheetUtil.TIMEZONE_WIDTH);
        CalcFileWriter.setColumnWidth(table, 20, SpreadsheetUtil.INCEPTION_YEAR_WIDTH);
        if (hasExtendedInfo) {
            CalcFileWriter.autosizeColumns(table, rows, new Pair[]{new ImmutablePair((Object)25, (Object)28), new ImmutablePair((Object)31, (Object)32), new ImmutablePair((Object)35, (Object)36), new ImmutablePair((Object)39, (Object)40)});
        }
    }

    @SafeVarargs
    private static void autosizeColumns(OdfTable sheet, int rows, Pair<Integer, Integer> ... ranges) {
        for (Pair<Integer, Integer> range : ranges) {
            for (int i = ((Integer)range.getLeft()).intValue(); i < (Integer)range.getRight(); ++i) {
                float sizeFactor = 2.0f;
                float size = 25.0f;
                for (int row = 0; row < rows; ++row) {
                    OdfTableCell cell = sheet.getCellByPosition(i, row);
                    if (!VALUE_TYPE_STRING.equals(cell.getValueType())) continue;
                    String stringValue = cell.getStringValue();
                    size = Math.max((float)stringValue.length() * 2.0f, size);
                }
                OdfTableColumn column = sheet.getColumnByIndex(i);
                column.setUseOptimalWidth(true);
                column.setWidth((long)size);
            }
        }
    }

    private static int addInfoFileList(CellListParameter cellListParameter, SpreadsheetUtil.CurrentRowData currentRowData, int startColumn, int columnsToFill, List<InfoFile> infoFiles) {
        return CalcFileWriter.addList(cellListParameter, currentRowData, startColumn, columnsToFill, infoFiles, (infoFileRow, infoFile) -> {
            String copyrightLines = Optional.ofNullable(infoFile.getExtractedCopyrightLines()).map(strings -> String.join((CharSequence)"\u00a7", strings)).orElse(null);
            CalcFileWriter.createDataCellsInRow(infoFileRow, startColumn, cellListParameter.getCellStyle(), infoFile.getContent().replace("\f", "\n"), copyrightLines, infoFile.getFileName());
        });
    }

    private static <T> int addList(CellListParameter cellListParameter, SpreadsheetUtil.CurrentRowData currentRowData, int startColumn, int columnsToFill, List<T> list, BiConsumer<OdfTableRow, T> biConsumer) {
        if (!CollectionUtils.isEmpty(list)) {
            for (int i = 0; i < list.size(); ++i) {
                T type = list.get(i);
                Integer index = currentRowData.getCurrentRowIndex() + i;
                OdfTableRow row = cellListParameter.getRows().get(index);
                if (row == null) {
                    row = cellListParameter.getSheet().appendRow();
                    cellListParameter.getRows().put(index, row);
                    if (cellListParameter.getCellStyle() != null) {
                        CalcFileWriter.createAndStyleCells(row, cellListParameter.getCellStyle(), new Pair[]{new ImmutablePair((Object)0, (Object)1), new ImmutablePair((Object)2, (Object)5), new ImmutablePair((Object)6, (Object)11)});
                        if (currentRowData.isHasExtendedInfo()) {
                            CalcFileWriter.createAndStyleCells(row, cellListParameter.getCellStyle(), new Pair[]{new ImmutablePair((Object)12, (Object)19), new ImmutablePair((Object)20, (Object)24), new ImmutablePair((Object)25, (Object)28), new ImmutablePair((Object)33, (Object)36), new ImmutablePair((Object)29, (Object)32), new ImmutablePair((Object)37, (Object)40)});
                        }
                    }
                    currentRowData.setExtraRows(currentRowData.getExtraRows() + 1);
                }
                biConsumer.accept(row, (OdfTableRow)type);
            }
        } else if (cellListParameter.cellStyle != null) {
            CalcFileWriter.setStyleOnEmptyCells(cellListParameter, currentRowData, startColumn, columnsToFill);
        }
        return currentRowData.getExtraRows();
    }

    private static void setStyleOnEmptyCells(CellListParameter cellListParameter, SpreadsheetUtil.CurrentRowData currentRowData, int startColumn, int columnsToFill) {
        OdfTableRow row = cellListParameter.getRows().get(currentRowData.getCurrentRowIndex());
        for (int i = 0; i < columnsToFill; ++i) {
            OdfTableCell cell = row.getCellByIndex(startColumn + i);
            cell.setValueType(VALUE_TYPE_STRING);
            cell.getOdfElement().setStyleName(CalcFileWriter.getCellStyleName(cellListParameter.getCellStyle()));
        }
    }

    @SafeVarargs
    private static void createAndStyleCells(OdfTableRow row, OdfStyle cellStyle, Pair<Integer, Integer> ... ranges) {
        for (Pair<Integer, Integer> range : ranges) {
            for (int i = ((Integer)range.getLeft()).intValue(); i < (Integer)range.getRight(); ++i) {
                OdfTableCell cell = row.getCellByIndex(i);
                cell.setValueType(VALUE_TYPE_STRING);
                cell.getOdfElement().setStyleName(CalcFileWriter.getCellStyleName(cellStyle));
            }
        }
    }

    public static void applyHyperlink(OdfTable table, OdfTableCell cell, String hyperlink, boolean isEmail) {
        TextAElement aElement = (TextAElement)((OdfContentDom)table.getOdfElement().getOwnerDocument()).newOdfElement(TextAElement.class);
        aElement.setXlinkTypeAttribute("simple");
        hyperlink = hyperlink.trim().replace(" dot ", ".");
        if (isEmail && (hyperlink = hyperlink.replace(" at ", "@")).contains("@") && hyperlink.matches(".*\\s[a-zA-Z]{2,3}$")) {
            hyperlink = hyperlink.replace(" ", ".");
        }
        aElement.setXlinkHrefAttribute(isEmail ? "mailto:" + hyperlink : hyperlink);
        aElement.setTextContent(hyperlink);
        Node node = cell.getOdfElement().getFirstChild();
        node.appendChild((Node)aElement);
    }

    private static void addHyperlinkIfExists(OdfTable table, OdfTableCell cell, OdfStyle hyperlinkStyle) {
        CalcFileWriter.addHyperlinkIfExists(table, cell, hyperlinkStyle, false);
    }

    private static void addHyperlinkIfExists(OdfTable table, OdfTableCell cell, OdfStyle hyperlinkStyle, boolean isEmail) {
        if (!StringUtils.isEmpty((CharSequence)cell.getStringValue())) {
            try {
                cell.getOdfElement().setStyleName(CalcFileWriter.getCellStyleName(hyperlinkStyle));
                String content = cell.getStringValue();
                cell.setStringValue("");
                CalcFileWriter.applyHyperlink(table, cell, content, isEmail);
            }
            catch (IllegalArgumentException e) {
                LOG.debug("Can't set Hyperlink for cell value " + cell.getStringValue() + " it gets rejected as URI", (Throwable)e);
            }
        }
    }

    private static OdfTableCell[] createDataCellsInRow(OdfTableRow row, int startColumn, OdfStyle cellStyle, String ... names) {
        OdfTableCell[] result = new OdfTableCell[names.length];
        for (int i = 0; i < names.length; ++i) {
            OdfTableCell cell = row.getCellByIndex(startColumn + i);
            cell.setValueType(VALUE_TYPE_STRING);
            if (cellStyle != null) {
                cell.getOdfElement().setStyleName(CalcFileWriter.getCellStyleName(cellStyle));
            }
            if (!StringUtils.isEmpty((CharSequence)names[i])) {
                int maxCellStringLength = Short.MAX_VALUE;
                String value = names[i].length() > Short.MAX_VALUE ? names[i].substring(0, 32764) + "..." : names[i];
                cell.setStringValue(value);
            }
            result[i] = cell;
        }
        return result;
    }

    private static void createDataCellsInRow(OdfTableRow row, int startColumn, OdfStyle cellStyle, int count) {
        for (int i = 0; i < count; ++i) {
            OdfTableCell cell = row.getCellByIndex(startColumn + i);
            cell.setValueType(VALUE_TYPE_STRING);
            if (cellStyle != null) {
                cell.getOdfElement().setStyleName(CalcFileWriter.getCellStyleName(cellStyle));
            }
            cell.setStringValue("");
        }
    }

    private static String getCellStyleName(OdfStyle cellStyle) {
        return cellStyle.getAttributes().item(1).getNodeValue();
    }

    private static void createInfoFileCellsInRow(OdfTableRow row, String styleName, int ... startPositions) {
        for (int startPosition : startPositions) {
            CalcFileWriter.createCellsInRow(row, startPosition, styleName, "Content", "Extracted copyright lines", "File");
        }
    }

    private static void createCellsInRow(OdfTableRow row, int startColumn, String styleName, String ... names) {
        for (int i = 0; i < names.length; ++i) {
            OdfTableCell cell = row.getCellByIndex(startColumn + i);
            cell.setValueType(VALUE_TYPE_STRING);
            cell.getOdfElement().setStyleName(styleName);
            cell.setStringValue(names[i]);
        }
    }

    private static void createMergedCellsInRow(OdfTable table, int startColumn, int endColumn, OdfTableRow row, String cellValue, int rowIndex, String styleName) {
        boolean merge;
        OdfTableCell cell = CalcFileWriter.createCellsInRow(startColumn, endColumn, row);
        if (cell == null) {
            return;
        }
        boolean bl = merge = endColumn - 1 > startColumn;
        if (merge) {
            OdfTableCellRange cellRange = table.getCellRangeByPosition(startColumn, rowIndex, endColumn - 1, rowIndex);
            cellRange.merge();
        }
        cell.setStringValue(cellValue);
        cell.getOdfElement().setStyleName(styleName);
    }

    private static OdfTableCell createCellsInRow(int startColumn, int exclusiveEndColumn, OdfTableRow inRow) {
        OdfTableCell firstCell = null;
        for (int i = startColumn; i < exclusiveEndColumn; ++i) {
            OdfTableCell cell = inRow.getCellByIndex(i);
            if (i != startColumn) continue;
            firstCell = cell;
        }
        return firstCell;
    }

    private static class CellListParameter {
        private final OdfTable sheet;
        private final Map<Integer, OdfTableRow> rows;
        private final OdfStyle cellStyle;

        private CellListParameter(OdfTable sheet, Map<Integer, OdfTableRow> rows, OdfStyle cellStyle) {
            this.sheet = sheet;
            this.rows = rows;
            this.cellStyle = cellStyle;
        }

        OdfTable getSheet() {
            return this.sheet;
        }

        Map<Integer, OdfTableRow> getRows() {
            return this.rows;
        }

        OdfStyle getCellStyle() {
            return this.cellStyle;
        }
    }
}

