/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.license.AbstractLicenseMojo;
import org.codehaus.mojo.license.FileState;
import org.codehaus.mojo.license.api.FreeMarkerHelper;
import org.codehaus.mojo.license.header.transformer.FileHeaderTransformer;
import org.codehaus.mojo.license.model.Copyright;
import org.codehaus.mojo.license.model.License;
import org.codehaus.mojo.license.model.LicenseStore;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractLicenseNameMojo
extends AbstractLicenseMojo {
    protected static final String[] DEFAULT_INCLUDES = new String[]{"**/*"};
    protected static final String[] DEFAULT_EXCLUDES = new String[]{"**/*.zargo", "**/*.uml", "**/*.umldi", "**/*.xmi", "**/*.img", "**/*.png", "**/*.jpg", "**/*.jpeg", "**/*.gif", "**/*.zip", "**/*.jar", "**/*.war", "**/*.ear", "**/*.tgz", "**/*.gz"};
    protected static final String[] DEFAULT_ROOTS = new String[]{"src", "target/generated-sources", "target/processed-sources"};
    @Parameter(property="license.licenseResolver")
    private String licenseResolver;
    @Parameter(property="license.keepBackup", defaultValue="false")
    private boolean keepBackup;
    @Parameter(property="license.licenseName")
    private String licenseName;
    @Parameter(property="license.projectName", defaultValue="${project.name}", required=true)
    protected String projectName;
    @Parameter(property="license.organizationName", defaultValue="${project.organization.name}", required=true)
    protected String organizationName;
    @Parameter(property="license.inceptionYear", defaultValue="${project.inceptionYear}", required=true)
    protected Integer inceptionYear;
    @Parameter(property="license.copyrightOwners")
    protected String copyrightOwners;
    @Parameter
    protected Map<String, String> extraTemplateParameters;
    private License license;
    private LicenseStore licenseStore;

    @Override
    protected void init() throws Exception {
        this.licenseStore = LicenseStore.createLicenseStore(this.getLog(), this.licenseResolver);
        this.license = this.getLicense(this.licenseName, true);
        if (StringUtils.isBlank((CharSequence)this.copyrightOwners)) {
            this.copyrightOwners = this.organizationName;
        }
    }

    protected License getLicense(String licenseName, boolean checkIfExists) {
        if (StringUtils.isEmpty((CharSequence)licenseName)) {
            throw new IllegalArgumentException("licenseName can not be null, nor empty");
        }
        if (this.licenseStore == null) {
            throw new IllegalStateException("No license store initialized!");
        }
        License result = this.licenseStore.getLicense(licenseName);
        if (checkIfExists && result == null) {
            throw new IllegalArgumentException("License named '" + licenseName + "' is unknown, use one of " + Arrays.toString(this.licenseStore.getLicenseNames()));
        }
        return result;
    }

    protected boolean isKeepBackup() {
        return this.keepBackup;
    }

    protected String getLicenseName() {
        return this.licenseName;
    }

    protected License getLicense() {
        return this.license;
    }

    protected String getCopyrightOwners() {
        String holder = this.copyrightOwners;
        if (holder == null) {
            holder = this.organizationName;
        }
        return holder;
    }

    protected String processLicenseContext(String licenseContent) throws IOException {
        FreeMarkerHelper licenseFreeMarkerHelper = FreeMarkerHelper.newHelperFromContent(licenseContent);
        HashMap<String, Object> templateParameters = new HashMap<String, Object>();
        this.addPropertiesToContext(System.getProperties(), "env_", templateParameters);
        this.addPropertiesToContext(this.getProject().getProperties(), "project_", templateParameters);
        templateParameters.put("project", this.getProject().getModel());
        templateParameters.put("organizationName", this.organizationName);
        templateParameters.put("inceptionYear", this.inceptionYear);
        templateParameters.put("copyright", this.getCopyright(this.getCopyrightOwners()));
        templateParameters.put("projectName", this.projectName);
        this.addPropertiesToContext(this.extraTemplateParameters, "extra_", templateParameters);
        return licenseFreeMarkerHelper.renderTemplate("template", templateParameters);
    }

    Copyright getCopyright(String holder) {
        return Copyright.newCopyright(this.inceptionYear, holder);
    }

    void getFilesToTreatForRoots(String[] includes, String[] excludes, List<String> roots, Map<File, String[]> files) {
        DirectoryScanner ds = new DirectoryScanner();
        ds.setIncludes(includes);
        if (excludes != null) {
            ds.setExcludes(excludes);
        }
        for (String src : roots) {
            File f = new File(src);
            if (!f.exists()) continue;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("discovering source files in " + src));
            }
            ds.setBasedir(f);
            ds.scan();
            String[] tmp = ds.getIncludedFiles();
            if (tmp.length < 1) continue;
            ArrayList toTreate = new ArrayList();
            Collections.addAll(toTreate, tmp);
            if (toTreate.isEmpty()) continue;
            files.put(f, toTreate.toArray(new String[toTreate.size()]));
        }
    }

    String cleanHeaderConfiguration(String value, String defaultValue) {
        String resultHeader = StringUtils.isEmpty((CharSequence)value) ? defaultValue : value.replaceAll("\\s", "");
        return resultHeader;
    }

    FileHeaderTransformer getTransformer(Map<String, FileHeaderTransformer> transformers, String transformerName) {
        if (StringUtils.isEmpty((CharSequence)transformerName)) {
            throw new IllegalArgumentException("transformerName can not be null, nor empty!");
        }
        if (transformers == null) {
            throw new IllegalStateException("No transformers initialized!");
        }
        FileHeaderTransformer transformer = transformers.get(transformerName);
        if (transformer == null) {
            throw new IllegalArgumentException("transformerName " + transformerName + " is unknow, use one this one : " + transformers.keySet());
        }
        return transformer;
    }

    void reportType(EnumMap<FileState, Set<File>> result, FileState state, StringBuilder buffer) {
        String operation = state.name();
        Set<File> set = this.getFiles(result, state);
        if (set == null || set.isEmpty()) {
            if (this.isVerbose()) {
                buffer.append("\n * no header to ");
                buffer.append(operation);
                buffer.append(".");
            }
            return;
        }
        buffer.append("\n * ").append(operation).append(" header on ");
        buffer.append(set.size());
        if (set.size() == 1) {
            buffer.append(" file.");
        } else {
            buffer.append(" files.");
        }
        if (this.isVerbose()) {
            for (File file : set) {
                buffer.append("\n   - ").append(file);
            }
        }
    }

    Map<String, List<File>> obtainFilesToProcessByCommentStyle(Map<String, String> extraFiles, String[] roots, String[] includes, String[] excludes, Map<String, String> extensionToCommentStyle, Map<String, FileHeaderTransformer> transformers) {
        HashMap<String, List<File>> results = new HashMap<String, List<File>>();
        for (String string : transformers.keySet()) {
            results.put(string, new ArrayList());
        }
        ArrayList<String> rootsList = new ArrayList<String>(roots.length);
        for (String string : roots) {
            File f = new File(string);
            if (f.isAbsolute()) {
                rootsList.add(f.getAbsolutePath());
            } else {
                f = new File(this.getProject().getBasedir(), string);
            }
            if (f.exists()) {
                this.getLog().info((CharSequence)("Will search files to update from root " + f));
                rootsList.add(f.getAbsolutePath());
                continue;
            }
            if (!this.isVerbose()) continue;
            this.getLog().info((CharSequence)("Skip not found root " + f));
        }
        HashMap<File, String[]> hashMap = new HashMap<File, String[]>();
        this.getFilesToTreatForRoots(includes, excludes, rootsList, hashMap);
        for (Map.Entry entry : hashMap.entrySet()) {
            String[] filesPath;
            File file = (File)entry.getKey();
            for (String path : filesPath = (String[])entry.getValue()) {
                File file2;
                String extension = FileUtils.extension((String)path);
                String commentStyle = extensionToCommentStyle.get(extension);
                if (StringUtils.isEmpty((CharSequence)commentStyle) && StringUtils.isEmpty((CharSequence)(commentStyle = extraFiles.get((file2 = new File(file, path)).getName())))) continue;
                file2 = new File(file, path);
                List files = (List)results.get(commentStyle);
                files.add(file2);
            }
        }
        return results;
    }

    private Set<File> getFiles(EnumMap<FileState, Set<File>> result, FileState state) {
        return result.get((Object)state);
    }

    private void addPropertiesToContext(Map properties, String prefix, Map<String, Object> context) {
        if (properties != null) {
            for (Object o : properties.keySet()) {
                String nextKey = (String)o;
                Object nextValue = properties.get(nextKey);
                context.put(prefix + nextKey, nextValue.toString());
            }
        }
    }
}

