/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.mojo.license.AbstractLicenseMojo;
import org.codehaus.mojo.license.api.DefaultThirdPartyHelper;
import org.codehaus.mojo.license.api.DependenciesTool;
import org.codehaus.mojo.license.api.ThirdPartyHelper;
import org.codehaus.mojo.license.api.ThirdPartyTool;
import org.codehaus.mojo.license.api.ThirdPartyToolException;
import org.codehaus.mojo.license.model.LicenseMap;
import org.codehaus.mojo.license.utils.FileUtil;
import org.codehaus.mojo.license.utils.MojoHelper;
import org.codehaus.mojo.license.utils.SortedProperties;
import org.codehaus.mojo.license.utils.StringToList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAddThirdPartyMojo
extends AbstractLicenseMojo {
    @Parameter(property="license.outputDirectory", defaultValue="${project.build.directory}/generated-sources/license", required=true)
    private File outputDirectory;
    @Parameter(property="license.thirdPartyFilename", defaultValue="THIRD-PARTY.txt", required=true)
    private String thirdPartyFilename;
    @Parameter(property="license.useMissingFile", defaultValue="false")
    private boolean useMissingFile;
    @Parameter(property="license.missingFile", defaultValue="src/license/THIRD-PARTY.properties")
    private File missingFile;
    @Parameter(property="license.overrideFile", defaultValue="src/license/override-THIRD-PARTY.properties")
    private File overrideFile;
    @Parameter
    private List<String> licenseMerges;
    @Parameter(property="license.includedLicenses", defaultValue="")
    private IncludedLicenses includedLicenses;
    @Parameter(property="license.excludedLicenses", defaultValue="")
    private ExcludedLicenses excludedLicenses;
    @Parameter(property="license.bundleThirdPartyPath", defaultValue="META-INF/${project.artifactId}-THIRD-PARTY.txt")
    private String bundleThirdPartyPath;
    @Parameter(property="license.generateBundle", defaultValue="false")
    private boolean generateBundle;
    @Parameter(property="license.force", defaultValue="false")
    private boolean force;
    @Parameter(property="license.failIfWarning", defaultValue="false")
    private boolean failIfWarning;
    @Parameter(property="license.sortArtifactByName", defaultValue="false")
    private boolean sortArtifactByName;
    @Parameter(property="license.fileTemplate", defaultValue="/org/codehaus/mojo/license/third-party-file.ftl")
    private String fileTemplate;
    @Parameter(property="localRepository", required=true, readonly=true)
    private ArtifactRepository localRepository;
    @Parameter(property="project.remoteArtifactRepositories", required=true, readonly=true)
    private List<ArtifactRepository> remoteRepositories;
    @Parameter(property="project.artifacts", required=true, readonly=true)
    private Set<Artifact> dependencies;
    @Component
    private ThirdPartyTool thirdPartyTool;
    @Component
    private DependenciesTool dependenciesTool;
    private ThirdPartyHelper helper;
    private SortedMap<String, MavenProject> projectDependencies;
    private LicenseMap licenseMap;
    private SortedSet<MavenProject> unsafeDependencies;
    private File thirdPartyFile;
    private SortedProperties unsafeMappings;
    private boolean doGenerate;
    private boolean doGenerateBundle;
    private Map<String, String> globalKnownLicenses;

    protected abstract SortedMap<String, MavenProject> loadDependencies();

    protected abstract SortedProperties createUnsafeMapping() throws ProjectBuildingException, IOException, ThirdPartyToolException;

    @Override
    protected void init() throws Exception {
        Log log = this.getLog();
        if (log.isDebugEnabled()) {
            this.setVerbose(true);
        }
        this.thirdPartyFile = new File(this.getOutputDirectory(), this.thirdPartyFilename);
        long buildTimestamp = this.getBuildTimestamp();
        if (this.isVerbose()) {
            log.info((CharSequence)("Build start   at : " + buildTimestamp));
            log.info((CharSequence)("third-party file : " + this.thirdPartyFile.lastModified()));
        }
        boolean bl = this.doGenerate = this.isForce() || !this.thirdPartyFile.exists() || buildTimestamp > this.thirdPartyFile.lastModified();
        if (this.generateBundle) {
            File bundleFile = FileUtil.getFile(this.getOutputDirectory(), this.bundleThirdPartyPath);
            if (this.isVerbose()) {
                log.info((CharSequence)("bundle third-party file : " + bundleFile.lastModified()));
            }
            this.doGenerateBundle = this.isForce() || !bundleFile.exists() || buildTimestamp > bundleFile.lastModified();
        } else {
            this.doGenerateBundle = false;
        }
        this.projectDependencies = this.loadDependencies();
        this.licenseMap = this.getHelper().createLicenseMap(this.projectDependencies);
        this.unsafeDependencies = this.getHelper().getProjectsWithNoLicense(this.licenseMap);
        if (!CollectionUtils.isEmpty(this.unsafeDependencies) && this.isUseMissingFile() && this.isDoGenerate()) {
            this.unsafeMappings = this.createUnsafeMapping();
        }
        this.getHelper().mergeLicenses(this.licenseMerges, this.licenseMap);
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public boolean isFailIfWarning() {
        return this.failIfWarning;
    }

    public SortedMap<String, MavenProject> getProjectDependencies() {
        return this.projectDependencies;
    }

    public SortedSet<MavenProject> getUnsafeDependencies() {
        return this.unsafeDependencies;
    }

    public LicenseMap getLicenseMap() {
        return this.licenseMap;
    }

    public boolean isUseMissingFile() {
        return this.useMissingFile;
    }

    File getMissingFile() {
        return this.missingFile;
    }

    File getOverrideFile() {
        return this.overrideFile;
    }

    public SortedProperties getUnsafeMappings() {
        return this.unsafeMappings;
    }

    public boolean isForce() {
        return this.force;
    }

    public boolean isDoGenerate() {
        return this.doGenerate;
    }

    public boolean isDoGenerateBundle() {
        return this.doGenerateBundle;
    }

    public List<String> getExcludedLicenses() {
        return this.excludedLicenses.getData();
    }

    public List<String> getIncludedLicenses() {
        return this.includedLicenses.getData();
    }

    public void setIncludedLicenses(String includedLicenses) {
        this.includedLicenses = new IncludedLicenses(includedLicenses);
    }

    public void setExcludedLicenses(String excludedLicenses) {
        this.excludedLicenses = new ExcludedLicenses(excludedLicenses);
    }

    protected ThirdPartyHelper getHelper() {
        if (this.helper == null) {
            this.helper = new DefaultThirdPartyHelper(this.getProject(), this.getEncoding(), this.isVerbose(), this.dependenciesTool, this.thirdPartyTool, this.localRepository, this.remoteRepositories, this.getLog());
        }
        return this.helper;
    }

    protected void resolveUnsafeDependenciesFromArtifact(String groupId, String artifactId, String version) throws ArtifactNotFoundException, IOException, ArtifactResolutionException {
        File missingLicensesFromArtifact = this.thirdPartyTool.resolveMissingLicensesDescriptor(groupId, artifactId, version, this.localRepository, this.remoteRepositories);
        this.resolveUnsafeDependenciesFromFile(missingLicensesFromArtifact);
    }

    protected void resolveUnsafeDependenciesFromFile(File missingLicenses) throws IOException {
        SortedSet<MavenProject> unsafeDeps = this.getUnsafeDependencies();
        if (missingLicenses != null && missingLicenses.exists() && missingLicenses.length() > 0L) {
            SortedProperties unsafeMappings = new SortedProperties(this.getEncoding());
            if (missingLicenses.exists()) {
                unsafeMappings.load(missingLicenses);
            }
            HashSet<MavenProject> resolvedDependencies = new HashSet<MavenProject>();
            for (MavenProject unsafeDependency : unsafeDeps) {
                String id = MojoHelper.getArtifactId(unsafeDependency.getArtifact());
                if (!unsafeMappings.containsKey(id) || !StringUtils.isNotBlank((CharSequence)unsafeMappings.getProperty(id))) continue;
                this.thirdPartyTool.addLicense(this.licenseMap, unsafeDependency, unsafeMappings.getProperty(id));
                resolvedDependencies.add(unsafeDependency);
            }
            unsafeDeps.removeAll(resolvedDependencies);
        }
    }

    protected boolean checkUnsafeDependencies() {
        boolean unsafe;
        SortedSet<MavenProject> unsafeDeps = this.getUnsafeDependencies();
        boolean bl = unsafe = !CollectionUtils.isEmpty(unsafeDeps);
        if (unsafe) {
            Log log = this.getLog();
            log.warn((CharSequence)("There is " + unsafeDeps.size() + " dependencies with no license :"));
            for (MavenProject dep : unsafeDeps) {
                log.warn((CharSequence)(" - " + MojoHelper.getArtifactId(dep.getArtifact())));
            }
        }
        return unsafe;
    }

    protected boolean checkForbiddenLicenses() {
        boolean safe;
        List<String> whiteLicenses = this.getIncludedLicenses();
        List<String> blackLicenses = this.getExcludedLicenses();
        HashSet<String> unsafeLicenses = new HashSet<String>();
        if (CollectionUtils.isNotEmpty(blackLicenses)) {
            Set licenses = this.getLicenseMap().keySet();
            this.getLog().info((CharSequence)("Excluded licenses (blacklist): " + blackLicenses));
            for (String excludeLicense : blackLicenses) {
                if (!licenses.contains(excludeLicense) || !CollectionUtils.isNotEmpty((Collection)((Collection)this.getLicenseMap().get(excludeLicense)))) continue;
                unsafeLicenses.add(excludeLicense);
            }
        }
        if (CollectionUtils.isNotEmpty(whiteLicenses)) {
            Set dependencyLicenses = this.getLicenseMap().keySet();
            this.getLog().info((CharSequence)("Included licenses (whitelist): " + whiteLicenses));
            block1: for (String dependencyLicense : dependencyLicenses) {
                this.getLog().debug((CharSequence)("Testing license '" + dependencyLicense + "'"));
                if (whiteLicenses.contains(dependencyLicense) || !CollectionUtils.isNotEmpty((Collection)((Collection)this.getLicenseMap().get(dependencyLicense)))) continue;
                this.getLog().debug((CharSequence)("Testing dependency license '" + dependencyLicense + "' against all other licenses"));
                for (MavenProject dependency : (SortedSet)this.getLicenseMap().get(dependencyLicense)) {
                    this.getLog().debug((CharSequence)("  testing dependency " + dependency));
                    boolean forbiddenLicenseUsed = true;
                    for (String otherLicense : dependencyLicenses) {
                        if (otherLicense.equals(dependencyLicense) || ((SortedSet)this.getLicenseMap().get(dependencyLicense)).isEmpty() || !whiteLicenses.contains(otherLicense) || !((SortedSet)this.getLicenseMap().get(otherLicense)).contains(dependency)) continue;
                        this.getLog().info((CharSequence)("License '" + dependencyLicense + "' for '" + dependency + "'is OK since it is also licensed under '" + otherLicense + "'"));
                        forbiddenLicenseUsed = false;
                        break;
                    }
                    if (!forbiddenLicenseUsed) continue;
                    unsafeLicenses.add(dependencyLicense);
                    continue block1;
                }
            }
        }
        if (!(safe = CollectionUtils.isEmpty(unsafeLicenses))) {
            Log log = this.getLog();
            log.warn((CharSequence)("There are " + unsafeLicenses.size() + " forbidden licenses used:"));
            for (String unsafeLicense : unsafeLicenses) {
                SortedSet deps = (SortedSet)this.getLicenseMap().get(unsafeLicense);
                if (deps.isEmpty()) continue;
                StringBuilder sb = new StringBuilder();
                sb.append("License ").append(unsafeLicense).append(" used by ").append(deps.size()).append(" dependencies:");
                for (MavenProject dep : deps) {
                    sb.append("\n -").append(MojoHelper.getArtifactName(dep));
                }
                log.warn((CharSequence)sb.toString());
            }
        }
        return safe;
    }

    protected void overrideLicenses() throws IOException {
        LicenseMap licenseMap1 = this.getLicenseMap();
        this.thirdPartyTool.overrideLicenses(licenseMap1, this.projectDependencies, this.getEncoding(), this.overrideFile);
    }

    protected void writeThirdPartyFile() throws IOException {
        if (this.doGenerate) {
            LicenseMap licenseMap1 = this.getLicenseMap();
            if (this.sortArtifactByName) {
                licenseMap1 = this.licenseMap.toLicenseMapOrderByName();
            }
            this.thirdPartyTool.writeThirdPartyFile(licenseMap1, this.thirdPartyFile, this.isVerbose(), this.getEncoding(), this.fileTemplate);
        }
        if (this.doGenerateBundle) {
            this.thirdPartyTool.writeBundleThirdPartyFile(this.thirdPartyFile, this.outputDirectory, this.bundleThirdPartyPath);
        }
    }

    public static class ExcludedLicenses
    extends StringToList {
        public ExcludedLicenses() {
        }

        public ExcludedLicenses(String data) {
            super(data);
        }

        public void setExcludedLicense(String excludeLicense) {
            this.addEntryToList(excludeLicense);
        }
    }

    public static class IncludedLicenses
    extends StringToList {
        public IncludedLicenses() {
        }

        public IncludedLicenses(String data) {
            super(data);
        }

        public void setIncludedLicense(String includeLicense) {
            this.addEntryToList(includeLicense);
        }
    }
}

