/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MojoHelper {
    protected static final double[] timeFactors = new double[]{1000000.0, 1000.0, 60.0, 60.0, 24.0};
    protected static final String[] timeUnites = new String[]{"ns", "ms", "s", "m", "h", "d"};

    public static boolean addResourceDir(File dir, MavenProject project, String ... includes) {
        List resources = project.getResources();
        return MojoHelper.addResourceDir(dir, project, resources, includes);
    }

    public static boolean addResourceDir(File dir, MavenProject project, List<?> resources, String ... includes) {
        String newresourceDir = dir.getAbsolutePath();
        boolean shouldAdd = true;
        for (Object o : resources) {
            Resource r = (Resource)o;
            if (!r.getDirectory().equals(newresourceDir)) continue;
            for (String i : includes) {
                if (r.getIncludes().contains(i)) continue;
                r.addInclude(i);
            }
            shouldAdd = false;
            break;
        }
        if (shouldAdd) {
            Resource r = new Resource();
            r.setDirectory(newresourceDir);
            for (String i : includes) {
                if (r.getIncludes().contains(i)) continue;
                r.addInclude(i);
            }
            project.addResource(r);
        }
        return shouldAdd;
    }

    public static String convertTime(long value) {
        return MojoHelper.convert(value, timeFactors, timeUnites);
    }

    public static String convert(long value, double[] factors, String[] unites) {
        long sign = value == 0L ? 1L : value / Math.abs(value);
        int i = 0;
        for (double tmp = (double)Math.abs(value); i < factors.length && i < unites.length && tmp > factors[i]; tmp /= factors[i++]) {
        }
        String result = MessageFormat.format("{0,number,0.###}{1}", tmp *= (double)sign, unites[i]);
        return result;
    }

    public static URL getUrl(URL baseUrl, String suffix) throws IllegalArgumentException {
        String url = baseUrl.toString() + "/" + suffix;
        try {
            return new URL(url);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("could not obtain url " + url, ex);
        }
    }
}

