/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.enforcer.ClassFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassesWithSameName {
    private final Log log;
    private final String classFilePath;
    private final List<ClassFile> list = new ArrayList<ClassFile>();

    public ClassesWithSameName(Log log, ClassFile initialClassFile, ClassFile ... additionalClassFiles) {
        this.log = log;
        this.classFilePath = initialClassFile.getClassFilePath();
        this.list.add(initialClassFile);
        for (ClassFile classFile : additionalClassFiles) {
            ClassesWithSameName.throwIfClassNameDoesNotMatch(classFile, this.classFilePath);
            this.list.add(classFile);
        }
    }

    public ClassFile previous() {
        if (this.list.size() > 1) {
            int lastIndex = this.list.size() - 2;
            return this.list.get(lastIndex);
        }
        throw new IllegalArgumentException("there was only " + this.list.size() + " element(s) in the list, so there is no 2nd-to-last element to retrieve ");
    }

    public void add(ClassFile classFile) {
        ClassesWithSameName.throwIfClassNameDoesNotMatch(classFile, this.classFilePath);
        this.list.add(classFile);
    }

    public Set<Artifact> getAllArtifactsThisClassWasFoundIn() {
        HashSet<Artifact> result = new HashSet<Artifact>();
        for (ClassFile classFile : this.list) {
            result.add(classFile.getArtifactThisClassWasFoundIn());
        }
        return result;
    }

    public boolean hasDuplicates(boolean ignoreWhenIdentical) {
        boolean compareJustClassNames;
        boolean bl = compareJustClassNames = !ignoreWhenIdentical;
        if (compareJustClassNames) {
            return this.list.size() > 1;
        }
        if (this.list.size() <= 1) {
            return false;
        }
        String previousHash = this.list.get(0).getHash();
        for (int i = 1; i < this.list.size(); ++i) {
            String currentHash = this.list.get(i).getHash();
            if (previousHash.equals(currentHash)) continue;
            return true;
        }
        this.log.debug((CharSequence)("ignoring duplicates of class " + this.classFilePath + " since the bytecode matches exactly"));
        return false;
    }

    public String toOutputString(boolean ignoreWhenIdentical) {
        String result = this.classFilePath;
        if (this.list.size() >= 2 && ignoreWhenIdentical) {
            StringBuilder duplicationInfo = new StringBuilder();
            for (Set<Artifact> groupedArtifacts : this.groupArtifactsWhoseClassesAreExactMatch().values()) {
                if (groupedArtifacts.size() <= 1) continue;
                if (duplicationInfo.length() == 0) {
                    duplicationInfo.append("  -- the bytecode exactly matches in these: ");
                } else {
                    duplicationInfo.append("; and more exact matches in these: ");
                }
                duplicationInfo.append(this.joinWithSeparator(groupedArtifacts, " and "));
            }
            result = result + duplicationInfo.toString();
        }
        return result;
    }

    private static void throwIfClassNameDoesNotMatch(ClassFile classFile, String otherClassFilePath) {
        if (!classFile.getClassFilePath().equals(otherClassFilePath)) {
            throw new IllegalArgumentException("Expected class " + otherClassFilePath + " but got " + classFile.getClassFilePath());
        }
    }

    private String joinWithSeparator(Set<Artifact> artifacts, String separator) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Artifact artifact : artifacts) {
            if (first) {
                first = false;
            } else {
                result.append(separator);
            }
            result.append(artifact);
        }
        return result.toString();
    }

    private Map<String, Set<Artifact>> groupArtifactsWhoseClassesAreExactMatch() {
        LinkedHashMap<String, Set<Artifact>> groupedArtifacts = new LinkedHashMap<String, Set<Artifact>>();
        for (ClassFile classFile : this.list) {
            LinkedHashSet<Artifact> artifacts = (LinkedHashSet<Artifact>)groupedArtifacts.get(classFile.getHash());
            if (artifacts == null) {
                artifacts = new LinkedHashSet<Artifact>();
            }
            artifacts.add(classFile.getArtifactThisClassWasFoundIn());
            groupedArtifacts.put(classFile.getHash(), artifacts);
        }
        return groupedArtifacts;
    }
}

