/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.report;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.mojo.chronos.common.model.GroupedResponsetimeSamples;
import org.codehaus.mojo.chronos.common.model.ResponsetimeSampleGroup;
import org.codehaus.mojo.chronos.report.ReportConfig;
import org.codehaus.mojo.chronos.report.ReportSink;
import org.codehaus.mojo.chronos.report.chart.ChartSource;
import org.codehaus.mojo.chronos.report.chart.GraphGenerator;

public final class ReportGenerator {
    private static final String IMG_EXT = ".png";
    private NumberFormat formatter = new DecimalFormat("#.#");
    private ReportConfig config;
    private ResourceBundle bundle;
    private ReportSink reportSink;
    private Sink sink;
    private GraphGenerator graphs;

    public ReportGenerator(ResourceBundle bundle, ReportConfig config, GraphGenerator graphs) {
        this.bundle = bundle;
        this.config = config;
        this.graphs = graphs;
    }

    public void doGenerateReport(Sink aSink, GroupedResponsetimeSamples samples) {
        this.reportSink = new ReportSink(this.bundle, aSink);
        this.sink = aSink;
        aSink.head();
        aSink.text(this.bundle.getString("chronos.description"));
        aSink.head_();
        aSink.body();
        this.constructReportHeaderSection();
        if (this.config.isShowsummary()) {
            this.constructReportSummarySection(samples);
        }
        if (this.config.isShowdetails()) {
            this.constructIndividualTestsSection(samples);
        }
        aSink.body_();
        aSink.flush();
        aSink.close();
    }

    private void constructReportHeaderSection() {
        String title = this.config.getTitle();
        String description = this.config.getDescription();
        String anchor = "Report" + this.config.getId();
        this.reportSink.constructHeaderSection(title, description, anchor);
        Map metadataFile = this.parseMetadata(this.config.getMetadata());
        String titleMetadata = this.bundle.getString("chronos.label.summary");
        String anchorMetadata = "Summary" + this.config.getId();
        this.reportSink.metadataTable(titleMetadata, anchorMetadata, metadataFile);
    }

    private Map parseMetadata(String metadata) {
        if (metadata == null || "null".equals(metadata)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> res = new LinkedHashMap<String, String>();
        BufferedReader br = null;
        try {
            String strLine;
            br = new BufferedReader(new FileReader(new File(metadata)));
            while ((strLine = br.readLine()) != null) {
                int tabIndex = strLine.indexOf(9);
                if (tabIndex == -1) {
                    res.put(strLine, "&lt;no value&gt;");
                    continue;
                }
                res.put(strLine.substring(0, tabIndex), strLine.substring(tabIndex + 1));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return res;
    }

    private void constructReportSummarySection(GroupedResponsetimeSamples samples) {
        String text = this.bundle.getString("chronos.label.summary");
        String anchor = "Summary" + this.config.getId();
        this.reportSink.title2(text, anchor);
        this.constructReportHotLinks();
        this.sink.table();
        this.sink.tableRow();
        this.reportSink.th("chronos.label.tests");
        if (this.config.isShowpercentile95()) {
            this.reportSink.th("chronos.label.percentile95");
        }
        if (this.config.isShowpercentile99()) {
            this.reportSink.th("chronos.label.percentile99");
        }
        this.reportSink.th("chronos.label.averagetime");
        this.reportSink.th("chronos.label.iterations");
        this.reportSink.th("chronos.label.successrate");
        this.sink.tableRow_();
        for (ResponsetimeSampleGroup sampleGroup : samples.getSampleGroups()) {
            this.sink.tableRow();
            this.reportSink.sinkCellLink(sampleGroup.getName(), "#a" + sampleGroup.getIndex() + this.config.getId());
            if (this.config.isShowpercentile95()) {
                double percentile95 = sampleGroup.getPercentile95();
                this.reportSink.sinkCell(this.formatter.format(percentile95));
            }
            if (this.config.isShowpercentile99()) {
                double percentile99 = sampleGroup.getPercentile99();
                this.reportSink.sinkCell(this.formatter.format(percentile99));
            }
            this.reportSink.sinkCell(this.formatter.format(sampleGroup.getAverage()));
            this.reportSink.sinkCell("" + sampleGroup.size());
            this.reportSink.sinkCell(this.formatter.format(sampleGroup.getSuccessrate()) + " %");
            this.sink.tableRow_();
        }
        this.sink.table_();
        this.reportSink.sinkLineBreak();
        for (ChartSource chartSource : this.graphs.getSummaryChartSources()) {
            if (!chartSource.isEnabled(this.config)) continue;
            this.reportSink.graphics(chartSource.getFileName(this.config) + IMG_EXT);
        }
    }

    private void constructIndividualTestsSection(GroupedResponsetimeSamples samples) {
        this.reportSink.title2(this.bundle.getString("chronos.label.testcases"), "Test_Cases" + this.config.getId());
        for (ResponsetimeSampleGroup sampleGroup : samples.getSampleGroups()) {
            this.constructReportHotLinks();
            this.reportSink.title3(sampleGroup.getName(), "a" + sampleGroup.getIndex() + this.config.getId());
            ArrayList<String> headerLabels = new ArrayList<String>();
            ArrayList<String> dataLine = new ArrayList<String>();
            headerLabels.add("chronos.label.mintime");
            dataLine.add(this.formatter.format(sampleGroup.getMin()));
            headerLabels.add("chronos.label.averagetime");
            dataLine.add(this.formatter.format(sampleGroup.getAverage()));
            if (this.config.isShowpercentile95()) {
                headerLabels.add("chronos.label.percentile95");
                dataLine.add(this.formatter.format(sampleGroup.getPercentile95()));
            }
            headerLabels.add("chronos.label.maxtime");
            dataLine.add(this.formatter.format(sampleGroup.getMax()));
            headerLabels.add("chronos.label.iterations");
            dataLine.add("" + sampleGroup.size());
            headerLabels.add("chronos.label.failures");
            dataLine.add(this.formatter.format(sampleGroup.getFailed()));
            headerLabels.add("chronos.label.successrate");
            dataLine.add(this.formatter.format(sampleGroup.getSuccessrate()) + " %");
            this.reportSink.table(headerLabels, Collections.singletonList(dataLine));
            if (!this.config.isShowdetails()) continue;
            for (ChartSource source : this.graphs.getDetailsChartSources(sampleGroup.getName())) {
                if (!source.isEnabled(this.config)) continue;
                this.reportSink.graphics(source.getFileName(this.config) + IMG_EXT);
            }
        }
        this.reportSink.sinkLineBreak();
    }

    private void constructReportHotLinks() {
        this.sink.section3();
        if (this.config.isShowsummary()) {
            this.reportSink.sinkLink(this.bundle.getString("chronos.label.summary"), "Summary" + this.config.getId());
        }
        if (this.config.isShowdetails()) {
            this.reportSink.sinkLink(this.bundle.getString("chronos.label.testcases"), "Test_Cases" + this.config.getId());
        }
        this.sink.section3_();
    }
}

