/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.report;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.mojo.chronos.common.TestDataDirectory;
import org.codehaus.mojo.chronos.common.model.GCSamples;
import org.codehaus.mojo.chronos.common.model.GroupedResponsetimeSamples;
import org.codehaus.mojo.chronos.common.model.ResponsetimeSampleGroup;
import org.codehaus.mojo.chronos.report.ReportConfig;
import org.codehaus.mojo.chronos.report.ReportGenerator;
import org.codehaus.mojo.chronos.report.Utils;
import org.codehaus.mojo.chronos.report.chart.ChartRendererImpl;
import org.codehaus.mojo.chronos.report.chart.ChartSource;
import org.codehaus.mojo.chronos.report.chart.DetailsHistogramChartSource;
import org.codehaus.mojo.chronos.report.chart.DetailsResponsetimeChartSource;
import org.codehaus.mojo.chronos.report.chart.GraphGenerator;
import org.codehaus.mojo.chronos.report.chart.SummaryGCChartSource;
import org.codehaus.mojo.chronos.report.chart.SummaryHistogramChartSource;
import org.codehaus.mojo.chronos.report.chart.SummaryResponsetimeChartSource;
import org.codehaus.mojo.chronos.report.chart.SummaryThroughputChartSource;
import org.xml.sax.SAXException;

public abstract class AbstractReportMojo
extends AbstractMavenReport {
    protected void generateReport(Locale locale) throws MavenReportException {
        try {
            TestDataDirectory testDataDirectory = this.getTestDataDirectory();
            GroupedResponsetimeSamples jmeterSamples = testDataDirectory.readResponsetimeSamples();
            if (jmeterSamples.getAllSamples().size() == 0) {
                throw new MavenReportException("Response time samples not found for " + this.getDataId());
            }
            this.getLog().info((CharSequence)("  tests: " + jmeterSamples.getSampleGroups().size()));
            this.getLog().info((CharSequence)("  jmeter samples: " + jmeterSamples.getAllSamples().size()));
            this.getLog().info((CharSequence)" generating charts...");
            GCSamples gcSamples = testDataDirectory.readGCSamples();
            ArrayList<ChartSource> summaryChartSources = new ArrayList<ChartSource>();
            summaryChartSources.add(new SummaryResponsetimeChartSource(jmeterSamples));
            summaryChartSources.add(new SummaryHistogramChartSource(jmeterSamples.getAllSamples()));
            summaryChartSources.add(new SummaryThroughputChartSource(jmeterSamples));
            summaryChartSources.add(new SummaryGCChartSource(gcSamples));
            LinkedHashMap<String, List<ChartSource>> detailsChartSources = new LinkedHashMap<String, List<ChartSource>>();
            for (ResponsetimeSampleGroup sampleGroup : jmeterSamples.getSampleGroups()) {
                ArrayList<ChartSource> sources = new ArrayList<ChartSource>();
                DetailsResponsetimeChartSource source = new DetailsResponsetimeChartSource(sampleGroup, jmeterSamples.getDateFormat());
                DetailsHistogramChartSource detailsHistogramChartSource = new DetailsHistogramChartSource(sampleGroup);
                sources.add(source);
                sources.add(detailsHistogramChartSource);
                detailsChartSources.put(sampleGroup.getName(), sources);
            }
            GraphGenerator graphGenerator = new GraphGenerator(summaryChartSources, detailsChartSources, this.getLog());
            ChartRendererImpl renderer = new ChartRendererImpl(this.getOutputDirectory());
            graphGenerator.generateGraphs(renderer, this.getBundle(locale), this.getConfig());
            ReportGenerator reportGenerator = new ReportGenerator(this.getBundle(locale), this.getConfig(), graphGenerator);
            this.getLog().info((CharSequence)" generating report...");
            Sink sink = this.getSink();
            reportGenerator.doGenerateReport(sink, jmeterSamples);
        }
        catch (IOException e) {
            throw new MavenReportException("ReportGenerator failed", (Exception)e);
        }
        catch (SAXException e) {
            throw new MavenReportException("ReportGenerator failed", (Exception)e);
        }
        catch (ParserConfigurationException e) {
            throw new MavenReportException("ReportGenerator failed", (Exception)e);
        }
    }

    protected abstract TestDataDirectory getTestDataDirectory();

    private ResourceBundle getBundle(Locale locale) {
        return Utils.getBundle(locale);
    }

    protected abstract ReportConfig getConfig();

    public String getOutputName() {
        return this.getConfig().getId();
    }

    protected abstract String getDataId();
}

