/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.report.chart;

import java.util.ResourceBundle;
import org.codehaus.mojo.chronos.common.model.ResponsetimeSamples;
import org.codehaus.mojo.chronos.report.ReportConfig;
import org.codehaus.mojo.chronos.report.chart.ChartUtil;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.xy.IntervalXYDataset;

public abstract class HistogramChartGenerator
extends ChartUtil {
    private static final int BINS = 100;
    private static final float FOREGROUND_ALPHA = 0.85f;

    protected final JFreeChart createHistogramChart(ResponsetimeSamples samples, String label, ResourceBundle bundle, ReportConfig config) {
        double value;
        HistogramDataset histogramdataset = new HistogramDataset();
        double[] sampleArray = samples.extractResponsetimes();
        histogramdataset.addSeries((Comparable)((Object)label), sampleArray, 100);
        JFreeChart chart = ChartFactory.createHistogram((String)bundle.getString("chronos.label.histogram"), (String)bundle.getString("chronos.label.histogram.x"), (String)bundle.getString("chronos.label.histogram.y"), (IntervalXYDataset)histogramdataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        XYPlot xyplot = (XYPlot)chart.getPlot();
        xyplot.setForegroundAlpha(0.85f);
        XYBarRenderer xybarrenderer = (XYBarRenderer)xyplot.getRenderer();
        xybarrenderer.setDrawBarOutline(false);
        if (config.isShowpercentile95()) {
            String label95 = bundle.getString("chronos.label.percentile95.arrow");
            value = samples.getPercentile95();
            ChartUtil.addDomainMarker(xyplot, label95, value);
        }
        if (config.isShowpercentile99()) {
            String label99 = bundle.getString("chronos.label.percentile99.arrow");
            value = samples.getPercentile99();
            ChartUtil.addDomainMarker(xyplot, label99, value);
        }
        if (config.isShowaverage()) {
            String label2 = bundle.getString("chronos.label.average.arrow");
            value = samples.getAverage();
            ChartUtil.addDomainMarker(xyplot, label2, value);
        }
        return chart;
    }
}

