/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.resolver.bod;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.codehaus.mojo.resolver.bod.build.BuildConfiguration;
import org.codehaus.mojo.resolver.bod.pom.rewrite.PomRewriteConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildOnDemandResolutionRequest {
    public static final String MODE_BUILD_ON_DEMAND = "build-on-demand";
    public static final String MODE_BINARY_ONLY = "binary-only";
    public static final String MODE_SOURCE_ONLY = "source-only";
    private static final Set<String> MODES;
    private MavenProject project;
    private List<MavenProject> currentPendingProjects;
    private Set<String> completedBuilds;
    private ArtifactRepository localRepository;
    private PomRewriteConfiguration pomRewriteConfiguration;
    private BuildConfiguration buildPrototype;
    private File projectsDirectory;
    private Settings settings;
    private String mode = "build-on-demand";

    public BuildConfiguration getBuildPrototype() {
        return this.buildPrototype;
    }

    public BuildOnDemandResolutionRequest setBuildPrototype(BuildConfiguration buildPrototype) {
        this.buildPrototype = buildPrototype;
        return this;
    }

    public Set<String> getCompletedBuilds() {
        return this.completedBuilds;
    }

    public BuildOnDemandResolutionRequest setCompletedBuilds(Set<String> completedBuilds) {
        this.completedBuilds = completedBuilds;
        return this;
    }

    public PomRewriteConfiguration getPomRewriteConfiguration() {
        return this.pomRewriteConfiguration;
    }

    public BuildOnDemandResolutionRequest setPomRewriteConfiguration(PomRewriteConfiguration injectedInfo) {
        this.pomRewriteConfiguration = injectedInfo;
        return this;
    }

    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    public BuildOnDemandResolutionRequest setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
        return this;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public BuildOnDemandResolutionRequest setProject(MavenProject project) {
        this.project = project;
        return this;
    }

    public File getProjectsDirectory() {
        return this.projectsDirectory;
    }

    public BuildOnDemandResolutionRequest setProjectsDirectory(File projectsDirectory) {
        this.projectsDirectory = projectsDirectory;
        return this;
    }

    public List<MavenProject> getCurrentPendingProjects() {
        return this.currentPendingProjects;
    }

    public BuildOnDemandResolutionRequest setCurrentPendingProjects(List<MavenProject> reactorProjects) {
        this.currentPendingProjects = reactorProjects;
        return this;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public BuildOnDemandResolutionRequest setSettings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public String getMode() {
        return this.mode;
    }

    public boolean useBuildOnDemandMode() {
        return MODE_BUILD_ON_DEMAND.equals(this.mode);
    }

    public boolean useBinaryOnlyMode() {
        return MODE_BINARY_ONLY.equals(this.mode);
    }

    public boolean useSourceOnlyMode() {
        return MODE_SOURCE_ONLY.equals(this.mode);
    }

    public BuildOnDemandResolutionRequest setMode(String mode) {
        if (mode == null || !MODES.contains(mode.toLowerCase())) {
            throw new IllegalArgumentException(BuildOnDemandResolutionRequest.getInvalidModeMessage(mode));
        }
        this.mode = mode.toLowerCase();
        return this;
    }

    public static boolean isModeValid(String mode) {
        return mode != null && MODES.contains(mode.toLowerCase());
    }

    public static String getInvalidModeMessage(String mode) {
        return "Invalid build-on-demand resolution mode: '" + mode + "' (must be one of: '" + MODE_BUILD_ON_DEMAND + "', '" + MODE_BINARY_ONLY + "', '" + MODE_SOURCE_ONLY + "').";
    }

    static {
        HashSet<String> modes = new HashSet<String>();
        modes.add(MODE_BUILD_ON_DEMAND);
        modes.add(MODE_BINARY_ONLY);
        modes.add(MODE_SOURCE_ONLY);
        MODES = modes;
    }
}

