/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.buildhelper;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.mappers.MapperException;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.codehaus.mojo.buildhelper.AbstractDefinePropertyMojo;
import org.codehaus.mojo.buildhelper.UpToDatePropertySetting;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractUpToDatePropertyMojo
extends AbstractDefinePropertyMojo {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected AbstractUpToDatePropertyMojo() {
    }

    protected void execute(UpToDatePropertySetting config) throws MojoExecutionException, MojoFailureException {
        try {
            config.validate();
        }
        catch (IllegalArgumentException e) {
            throw new MojoExecutionException("Invalid UpToDateProperty configuration", (Exception)e);
        }
        boolean upToDate = true;
        FileSet fileSet = config.getFileSet();
        if (fileSet != null) {
            try {
                FileSetManager fileSetManager = new FileSetManager(this.log);
                Map includedFiles = fileSetManager.mapIncludedFiles(fileSet);
                upToDate = !includedFiles.isEmpty();
                upToDate &= includedFiles.entrySet().parallelStream().allMatch(entry -> {
                    File srcFile = this.getFile(fileSet, false, (String)entry.getKey());
                    File targetFile = this.getFile(fileSet, true, (String)entry.getValue());
                    boolean isUpToDate = this.isUpToDate(srcFile, targetFile);
                    if (this.getLog().isDebugEnabled()) {
                        try {
                            StringBuilder msg = new StringBuilder(targetFile.getCanonicalPath());
                            if (!targetFile.exists()) {
                                msg.append(" (nonexistent)");
                            }
                            msg.append("\n\tis ").append(isUpToDate ? "up to date" : "out of date").append(" with respect to \n\t").append(srcFile.getCanonicalPath());
                            if (!srcFile.exists()) {
                                msg.append(" (nonexistent)");
                            }
                            this.getLog().debug((CharSequence)msg);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return isUpToDate;
                });
            }
            catch (MapperException e) {
                throw new MojoExecutionException("", (Exception)((Object)e));
            }
        }
        if (upToDate) {
            this.defineProperty(config.getName(), config.getValue().trim());
        } else if (!StringUtils.isBlank((String)config.getElse())) {
            this.defineProperty(config.getName(), config.getElse().trim());
        }
    }

    private File getFile(FileSet fileSet, boolean useOutputDirectory, String path) {
        String baseDir = useOutputDirectory && !StringUtils.isBlank((String)fileSet.getOutputDirectory()) ? fileSet.getOutputDirectory() : fileSet.getDirectory();
        return path == null ? null : new File(baseDir, path);
    }

    private boolean isUpToDate(File srcFile, File targetFile) {
        return srcFile != null && srcFile.exists() && (targetFile == null || srcFile.lastModified() <= targetFile.lastModified());
    }
}

