/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.buildhelper;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.buildhelper.AbstractDefinePropertyMojo;
import org.codehaus.mojo.buildhelper.RegexPropertySetting;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractRegexPropertyMojo
extends AbstractDefinePropertyMojo {
    protected void execute(RegexPropertySetting config) throws MojoExecutionException, MojoFailureException {
        Pattern pattern;
        try {
            config.validate();
        }
        catch (IllegalArgumentException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        try {
            pattern = Pattern.compile(config.getRegex());
        }
        catch (PatternSyntaxException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        Matcher matcher = pattern.matcher(config.getValue());
        if (matcher.find()) {
            config.setValue(StringUtils.isNotEmpty((String)config.getReplacement()) ? matcher.replaceAll(config.getReplacement()) : matcher.replaceAll(""));
        } else {
            if (config.isFailIfNoMatch()) {
                throw new MojoFailureException("No match to regex '" + config.getRegex() + "' found in '" + config.getValue() + "'.");
            }
            this.getLog().info((CharSequence)("No match to regex '" + config.getRegex() + "' found in '" + config.getValue() + "'. " + "The initial value '" + config.getValue() + "' is left as-is..."));
        }
        this.defineProperty(config.getName(), config.getValue());
    }
}

